@extends('layouts.syndron.app')

@section('content')
<div class="row">
    <div class="col-sm-4">
        <div class="card radius-15">
            <div class="card-body text-center">
                <div class="p-4 border radius-15">
                    <img src="{{ $user->profile_image ?? '/assets/themes/blesser/images/user.png' }}" width="110" height="110" class="rounded-circle shadow" alt="">
                    <h5 class="mb-0 mt-5">{{$user->name}}</h5>
                    <p class="mb-3">{{$user->email}}</p>

                </div>
            </div>
        </div>
        <div class="card radius-15">
            <div class="card-body text-center">
                <div class="p-1  radius-15 d-flex justify-content-right align-items-center flex-wrap">
                    <a href="<?= route('admin.settings.users.edit', $user->id) ?>" class="btn btn-outline-primary m-1"><i class="bx bx-edit-alt"></i>{{ __('edit user ')}}</a>
                    <a href="<?= route('admin.settings.user.role.assign', $user->id) ?>" class="btn btn-outline-primary m-1"><i class="bx bx-lock-alt"></i>{{ __('role assignment')}}</a>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-8">
        <section id="user-info">
            <!-- general info -->
            <div class="card radius-15">
                <div class="card-header">
                    <p class="header-title p-0 m-0">{{ __('user information') }}</p>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            {{ __('name') }}:
                            {{(isset($user->name)) ? $user->name : __('not defined')}}
                        </div>
                        <div class="col-sm-6">
                            {{ __('username') }}:
                            {{(isset($user->username)) ? $user->username : __('not defined')}}
                        </div>
                        <div class="col-sm-6">
                            {{ __('Social Number (ID Num)') }}:
                            {{(isset($user->social_number)) ? $user->social_number : __('not defined')}}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 mb-3">
                            {{ __('phone number ') }}:
                            {{(isset($user->phone))?$user->phone : __('not defined')}}
                        </div>
                        <div class="col-sm-12 mb-3">
                            {{ __('address') }}:
                            {{(isset($user->email))?$user->email : __('not defined')}}
                        </div>
                    </div>
                    <div class="d-flex justify-content-center">
                        <div type="button" class="btn btn-primary m-3">{{ __('wallet') }}<span class="badge bg-dark"> {{ $user->wallet->balance ?? 0 }} </span></div>
                    </div>
                </div>
            </div>


            <!-- user ability -->
            <div class="card radius-15">
                <div class="card-header">
                    <p class="header-title p-0 m-0">{{ __('user ability') }}</p>
                </div>
                <div class="card-body">
                    <p>{{ __('User\'s roles') }}</p>
                    <div class="d-flex flex-wrap mb-3">
                        @foreach($user->getRoleNames() as $role)
                        <span class="badge bg-dark m-2">{{ $role }}</span>
                        @endforeach
                    </div>
                    <p>{{ __('User\'s permissions') }}</p>
                    <div class="d-flex flex-wrap mb-3">
                        @foreach($user->getAllPermissions('name')->pluck('name') as $permissions)
                        <span class="badge bg-dark m-1">{{ $permissions }}</span>
                        @endforeach
                    </div>
                </div>
            </div>
            <!-- user validation -->
            <div class="card radius-15">
                <div class="card-header">
                    <p class="header-title p-0 m-0">{{ __('user validation ') }}</p>
                </div>
                <div class="card-body">
                    <div>
                        @if($user->email_verified_at != null)
                        <p>
                            <i class="fadeIn animated bx bx-check text-success"></i>
                            {{ __('user email has been verified') }}
                        </p>
                        @else
                        <p>
                            <i class="fadeIn animated bx bx-x text-danger"></i>
                            {{ __('user email has not been verified') }}
                        </p>
                        @endif
                    </div>
                    <div>
                        @if($user->phone_verified_at != null)
                        <p>
                            <i class="fadeIn animated bx bx-check text-success"></i>
                            {{ __('user phone number has been verified') }}
                        </p>
                        @else
                        <p>
                            <i class="fadeIn animated bx bx-x text-danger"></i>
                            {{ __('user phone number has not been verified') }}
                        </p>
                        @endif
                    </div>
                </div>
            </div>


        </section>
    </div>
</div>
@endsection
