@extends('layouts.syndron.app')

@section('content')
<div>

    <x-syndron.ui.table :columns="[ '#', 'image', 'product','status', 'price', 'inventory', 'action' ]">
        @foreach ($inventories as $inventory )
        <tr>
            <td>{{$loop->iteration }}</td>
            <td><img src="{{$inventory->product->brand_img }}" alt="{{$inventory->product->title }}" class="img-thumbnail" style="aspect-ratio: 1/1; width: 60px;"></td>
            <td>{{$inventory->product->title }}</td>

            <td>{{$inventory->status }}</td>
            <td>{{$inventory->price }}</td>
            <td>{{$inventory->inventory }}</td>

            <td>
                @if (in_array($inventory->name , config('app.roles')))
                <p> {{ __('create by system') }} </p>
                @else
                <div class="dropdown">
                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                        {{ __('Actions') }}
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                        <li><a class="dropdown-item" href="{{ route('product.details' ,$inventory->product->slug) }}">{{ __('see product in shop') }}</a></li>

                        @can('shop.inventory.edit')
                        <li><a class="dropdown-item" href="{{ route('admin.shop.add.inventory' ,$inventory->product->id) }}">{{ __('Edit') }}</a></li>
                        @endcan

                        @can('shop.inventory.variant.create')
                        <li><a class="dropdown-item" href="{{ route('admin.shop.inventory.variant.index' ,$inventory->id) }}">{{ __('Add variant') }}</a></li>
                        @endcan

                        @can('shop.inventory.delete')
                        <li>
                            <form action="{{ route('admin.shop.inventory.destroy' ,$inventory->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this attribute?') ?>');">
                                @csrf
                                @method('DELETE')
                                <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                            </form>
                        </li>
                        @endcan
                    </ul>
                </div>
                @endif

            </td>
        </tr>
        @endforeach
    </x-syndron.ui.table>



    {{ $inventories->links() }}
</div>
@endsection
