@extends('layouts.syndron.app')

@section('content')
<div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.shop.inventory.variant.store' , $inventory->id) }}" method="post">

                @csrf
                <x-syndron.form.product.category-attributes :category="$product->category" is_price_effective="1" item_value="0" />

                <div class="mb-3">
                    <label for="additional_price">{{ __('Additional Price') }}</label>
                    <input type="text" name="additional_price" class="form-control" id="additional_price" value="{{ old('additional_price') }}" placeholder="{{ __('Additional Price') }}">
                    @error('additional_price')
                    <small class="text-danger"> {{ $message }} </small>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="inventory_count">{{ __('Inventory Count') }}</label>
                    <input type="text" name="inventory_count" class="form-control" id="inventory_count" value="{{ old('inventory_count') }}" placeholder="{{ __('Inventory Count') }}">
                    @error('inventory_count')
                    <small class="text-danger"> {{ $message }} </small>
                    @enderror
                </div>
                <div class="d-flex justify-content-end">
                    <button class="btn btn-primary px-5" type="submit">
                        {{ __('Add') }}
                    </button>
                </div>
            </form>
        </div>
    </div>

    <x-syndron.ui.table :columns="[ '#', 'item_key', 'item_value','additional_price', 'inventory_count', 'action' ]">
        @foreach ($variants as $variant )
        <tr>
            <td>{{$loop->iteration }}</td>
            <td>{{$variant->item_key }}</td>
            <td>{{$variant->item_value }}</td>
            <td>{{$variant->additional_price }}</td>
            <td>{{$variant->inventory_count }}</td>

            <td>
                @if (in_array($variant->name , config('app.roles')))
                <p> {{ __('create by system') }} </p>
                @else
                <div class="dropdown">
                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                        {{ __('Actions') }}
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                        @can('shop.inventory.variant.delete')
                        <li>
                            <form action="{{ route('admin.shop.inventory.variant.destroy', ['inventory' => $inventory->id , 'variant'=>$variant->id ] ) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this attribute?') ?>');">
                                @csrf
                                @method('DELETE')
                                <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                            </form>
                        </li>
                        @endcan
                    </ul>
                </div>
                @endif

            </td>
        </tr>
        @endforeach
    </x-syndron.ui.table>

</div>
@endsection
