@extends('layouts.blesser.app')

@section('content')
<div class="container pb-28 pt-12 lg:pb-10">
    <div class="grid grid-cols-1 gap-6 md:grid-cols-2 lg:grid-cols-3 justify-items-center">
        @if($groups->isNotEmpty())
        @foreach($groups as $group)
        <x-blesser.ui.pricing-card
            :title="$group->name"
            :price="number_format($group->products->sum('price'))"
            :description="$group->description ?? 'Description for ' . $group->name"
            :features="$group->products->pluck('title')->toArray()"
            button-text="{{ __('View Details') }}"
            link="{{ route('office-equipment.products', $group) }}" />

        @endforeach
        @else
        <p>{{ __('No office equipment groups found.') }}</p>
        @endif
    </div>
</div>
@endsection
