<?php

use App\Livewire\Admin\PageItemEdit;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\TagController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\PostController;
use App\Http\Controllers\Admin\ShopController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\CommentController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ProductIndexController;
use App\Http\Controllers\Admin\CategoryAttributeController;
use App\Http\Controllers\Admin\OfficeEquipmentGroupController;
use App\Http\Controllers\Admin\CategoryAttributeItemController;

Route::view('dashboard', 'pages.admin.dashboard')->name('dashboard');


Route::get('comments', [CommentController::class, 'index'])->name('comments.index');
Route::post('comments/{comment}/status', [CommentController::class, 'updateStatus'])->name('comments.update.status');


Route::patch('shops/{shop}/approve', [ShopController::class, 'approve'])->name('shops.approve');
Route::patch('shops/{shop}/unapprove', [ShopController::class, 'unapprove'])->name('shops.unapprove');

Route::view('file-manager', 'pages.admin.file-manager')->name('file-manager');

Route::get('page/{page}/items', PageItemEdit::class)->name('page.items.edit');

Route::resources([
    'categories' => CategoryController::class,
    'category.attribute' => CategoryAttributeController::class,
    'attribute.item' => CategoryAttributeItemController::class,
    'product' => ProductController::class,
    'post' => PostController::class,
    'shops' => ShopController::class,
    'coupons' => CouponController::class,
    'orders' => OrderController::class,
    'office-equipment-groups' => OfficeEquipmentGroupController::class,
    'page' => PageController::class,
    'brands' => BrandController::class,
    'tags' => TagController::class,

]);
