<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Faq\TagController;
use App\Http\Controllers\Admin\Faq\FlagController;
use App\Http\Controllers\Admin\Faq\CategoryController;
use App\Http\Controllers\Admin\Faq\QuestionController;

Route::prefix('faq')->name('faq.')->group(function () {
    Route::get('/up', function () {
        return 'admin faq route group is active';
    });




    Route::resource('categories',  CategoryController::class);
    Route::resource('tags',  TagController::class);
    Route::resource('questions',  QuestionController::class);

    Route::get('flags', [FlagController::class, 'index'])->name('flags.index');
    Route::post('flags/{flag}/destroy', [FlagController::class, 'destroy'])->name('flags.destroy');
});
