<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Faq\TagController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\InventoryVariantController;
use App\Http\Controllers\Admin\Faq\CategoryController;
use App\Http\Controllers\Admin\Faq\QuestionController;
use App\Http\Controllers\Admin\Shop\InventoryController;
use App\Http\Controllers\Admin\Shop\AddInventoryController;
use App\Http\Controllers\Admin\Shop\ProductSelectionController;

Route::prefix('shop')->name('shop.')->group(function () {
    Route::get('/up', function () {
        return 'admin shop route group is active';
    });

    Route::get('select-product', [ProductController::class, 'index'])->name('product-selection');

    Route::get('add/inventory/{product}', [ProductController::class, 'show'])->name('add.inventory');

    Route::resource('inventory', InventoryController::class);
    Route::resource('inventory.variant', InventoryVariantController::class);
});
