<?php $__env->startSection('title', __('Order Details') . ' #' . $order->tracking_code); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <?php if (isset($component)) { $__componentOriginal752b27a43c0f1214fbe20c100bbbe849 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal752b27a43c0f1214fbe20c100bbbe849 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.syndron.ui.card.card','data' => ['title' => __('Order Information')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('syndron.ui.card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Order Information'))]); ?>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Tracking Code')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->tracking_code); ?></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Order UUID')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->uuid); ?></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Customer Name')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->name); ?></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Customer Email')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->email); ?></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Customer Phone')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->phone); ?></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Order Type')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e(__(ucfirst($order->type))); ?></div>
                </div>
                <hr>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Total Amount')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e(number_format($order->amount)); ?></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Discount')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->discount); ?></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Final Amount')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->amount_with_discount); ?></div>
                </div>
                <?php if($order->coupon): ?>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Coupon Used')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->coupon->code); ?></div>
                </div>
                <?php endif; ?>
                <hr>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Status')); ?>:</strong></div>
                    <div class="col-sm-8"><span class="badge bg-info"><?php echo e(__(ucfirst($order->status))); ?></span></div>
                </div>
                <?php if($order->reseller): ?>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Reseller')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->reseller); ?></div>
                </div>
                <?php endif; ?>
                <?php if($order->description): ?>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Description/Notes')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e($order->description); ?></div>
                </div>
                <?php endif; ?>
                <hr>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Order Date')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e(verta($order->created_at)->format('F j, Y, g:i a')); ?></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong><?php echo e(__('Last Updated')); ?>:</strong></div>
                    <div class="col-sm-8"><?php echo e(verta($order->updated_at)->format('F j, Y, g:i a')); ?></div>
                </div>

                <?php if($order->address): ?>
                <hr>
                <h5><?php echo e(__('Shipping Address')); ?></h5>
                <p><?php echo e($order->address->full_address_line_with_phone ?? $order->address->address_line_1); ?></p>
                <?php endif; ?>

                <?php if($order->deliveryTime): ?>
                <hr>
                <h5><?php echo e(__('Preferred Delivery Time')); ?></h5>
                <p><?php echo e($order->deliveryTime->name); ?></p>
                <?php endif; ?>

             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal752b27a43c0f1214fbe20c100bbbe849)): ?>
<?php $attributes = $__attributesOriginal752b27a43c0f1214fbe20c100bbbe849; ?>
<?php unset($__attributesOriginal752b27a43c0f1214fbe20c100bbbe849); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal752b27a43c0f1214fbe20c100bbbe849)): ?>
<?php $component = $__componentOriginal752b27a43c0f1214fbe20c100bbbe849; ?>
<?php unset($__componentOriginal752b27a43c0f1214fbe20c100bbbe849); ?>
<?php endif; ?>

            <?php if($order->items->count()): ?>
            <?php if (isset($component)) { $__componentOriginal752b27a43c0f1214fbe20c100bbbe849 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal752b27a43c0f1214fbe20c100bbbe849 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.syndron.ui.card.card','data' => ['title' => __('Order Items'),'class' => 'mt-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('syndron.ui.card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Order Items')),'class' => 'mt-4']); ?>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Product')); ?></th>
                                <th><?php echo e(__('Quantity')); ?></th>
                                <th><?php echo e(__('Unit Price')); ?></th>
                                <th><?php echo e(__('Total Price')); ?></th>
                                <th><?php echo e(__('Supplier store')); ?></th>
                                <th><?php echo e(__('Product')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($item->name ?? $item->product->title ?? __('N/A')); ?></td>
                                <td><?php echo e($item->count); ?></td>
                                <td><?php echo e(number_format($item->price)); ?> <?php echo e(getCurrency()); ?></td>
                                <td><?php echo e(number_format($item->count * $item->price)); ?> <?php echo e(getCurrency()); ?></td>
                                <td>
                                    <?php if($item->inventory): ?>
                                    <a href="<?php echo e(route('admin.shops.show', $item->inventory->shop_id)); ?>">
                                        <?php echo e($item->inventory->seller->name); ?>

                                    </a>
                                    <?php endif; ?>
                                </td>
                                <td><a href="<?php echo e(route('admin.product.show' , $item->item_id)); ?>"><?php echo e(__('see product')); ?></a></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal752b27a43c0f1214fbe20c100bbbe849)): ?>
<?php $attributes = $__attributesOriginal752b27a43c0f1214fbe20c100bbbe849; ?>
<?php unset($__attributesOriginal752b27a43c0f1214fbe20c100bbbe849); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal752b27a43c0f1214fbe20c100bbbe849)): ?>
<?php $component = $__componentOriginal752b27a43c0f1214fbe20c100bbbe849; ?>
<?php unset($__componentOriginal752b27a43c0f1214fbe20c100bbbe849); ?>
<?php endif; ?>
            <?php endif; ?>
        </div>

        <div class="col-md-4">
            <?php if (isset($component)) { $__componentOriginal752b27a43c0f1214fbe20c100bbbe849 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal752b27a43c0f1214fbe20c100bbbe849 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.syndron.ui.card.card','data' => ['title' => __('Associated Data')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('syndron.ui.card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Associated Data'))]); ?>
                <?php if($order->user): ?>
                <h6><?php echo e(__('Registered User (Customer)')); ?></h6>
                <p><a href="#"><?php echo e($order->user->name); ?> (<?php echo e($order->user->email); ?>)</a></p>
                <hr>
                <?php endif; ?>

                <?php if($order->createdBy): ?>
                <h6><?php echo e(__('Created By')); ?></h6>
                <p><?php echo e(__(class_basename($order->createdBy_type))); ?>: <?php echo e($order->createdBy->name ?? $order->createdBy->id); ?></p>
                <hr>
                <?php endif; ?>

                <?php if($order->orderedBy): ?>
                <h6><?php echo e(__('Ordered By (System)')); ?></h6>
                <p><?php echo e(__(class_basename($order->orderedBy_type))); ?>: <?php echo e($order->orderedBy->name ?? $order->orderedBy->id); ?></p>
                <hr>
                <?php endif; ?>

                <?php if($order->orderable): ?>
                <h6><?php echo e(__('Orderable Item (e.g., Subscription)')); ?></h6>
                <p><?php echo e(__(class_basename($order->orderable_type))); ?>: <?php echo e($order->orderable->name ?? $order->orderable->id); ?></p>
                <hr>
                <?php endif; ?>

                <?php if($order->deliveries->count()): ?>
                <h6><?php echo e(__('Deliveries')); ?></h6>
                <ul>
                    <?php $__currentLoopData = $order->deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($delivery->tracking_number ?? __('Delivery')); ?> - <?php echo e(__(ucfirst($delivery->status))); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <hr>
                <?php endif; ?>

                <?php if($order->payments->count()): ?>
                <h6><?php echo e(__('Payments')); ?></h6>
                <ul>
                    <?php $__currentLoopData = $order->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($payment->amount); ?> - <?php echo e(__(ucfirst($payment->status))); ?> (<?php echo e($payment->method); ?>)</li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <hr>
                <?php endif; ?>

                <?php if($order->metas->count()): ?>
                <h6><?php echo e(__('Order Meta')); ?></h6>
                <ul>
                    <?php $__currentLoopData = $order->metas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><strong><?php echo e(__($meta->key)); ?>:</strong> <?php echo e($meta->value); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <?php endif; ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal752b27a43c0f1214fbe20c100bbbe849)): ?>
<?php $attributes = $__attributesOriginal752b27a43c0f1214fbe20c100bbbe849; ?>
<?php unset($__attributesOriginal752b27a43c0f1214fbe20c100bbbe849); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal752b27a43c0f1214fbe20c100bbbe849)): ?>
<?php $component = $__componentOriginal752b27a43c0f1214fbe20c100bbbe849; ?>
<?php unset($__componentOriginal752b27a43c0f1214fbe20c100bbbe849); ?>
<?php endif; ?>
            <div class="mt-3">
                <a href="<?php echo e(route('admin.orders.edit', $order)); ?>" class="btn btn-primary"><?php echo e(__('Edit Order')); ?></a>
                <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-secondary"><?php echo e(__('Back to List')); ?></a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/order/show.blade.php ENDPATH**/ ?>