<?php $__env->startSection('content'); ?>
<div class="p-3 mb-4">
    <div class="alert alert-info" role="alert">
        <?php echo e(__('This page is currently under development. Its purpose is to centralize and update all website information in one place. However, features like file uploading and additional details are not yet available.')); ?>

    </div>
</div>
<?php $__sessionArgs = ['success'];
if (session()->has($__sessionArgs[0])) :
if (isset($value)) { $__sessionPrevious[] = $value; }
$value = session()->get($__sessionArgs[0]); ?>
<div>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <button
            type="button"
            class="btn-close"
            data-bs-dismiss="alert"
            aria-label="Close"></button>

        <?php echo e(session('success')); ?>

    </div>

    <script>
        var alertList = document.querySelectorAll(".alert");
        alertList.forEach(function(alert) {
            new bootstrap.Alert(alert);
        });
    </script>

</div>
<?php unset($value);
if (isset($__sessionPrevious) && !empty($__sessionPrevious)) { $value = array_pop($__sessionPrevious); }
if (isset($__sessionPrevious) && empty($__sessionPrevious)) { unset($__sessionPrevious); }
endif;
unset($__sessionArgs); ?>
<div x-data="optionManager()" class="container mt-5">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3">
            <div class="list-group">
                <h5 class="mb-3">Groups</h5>
                <template x-for="(keys, group) in groupedOptions" :key="group">
                    <button
                        type="button"
                        class="list-group-item list-group-item-action"
                        :class="{ 'active': currentGroup === group }"
                        @click="currentGroup = group"
                        x-text="group">
                    </button>
                </template>
            </div>
        </div>

        <!-- Content -->
        <div class="col-md-9">
            <form method="POST" action="<?php echo e(route('admin.option.update-all')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <template x-if="currentGroup && groupedOptions[currentGroup]">
                    <div>
                        <h3 class="mb-4" x-text="currentGroup"></h3>
                        <template x-for="(item, index) in groupedOptions[currentGroup]" :key="item.key">
                            <div class="card mb-4">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Option Key</label>
                                            <input type="text"
                                                class="form-control readonly"
                                                :name="`options[${item.id}][key]`"
                                                x-model="item.key"
                                                readonly>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Option Value</label>
                                            <input type="text"
                                                class="form-control"
                                                :name="`options[${item.id}][value]`"
                                                x-model="item.value">
                                        </div>

                                        <div class="col-12 mt-3">
                                            <label class="form-label fw-bold">Data (Dynamic JSON Editor)</label>
                                            <div class="border p-3 rounded bg-light">
                                                <template x-for="(value, key) in item.data" :key="key">
                                                    <div>
                                                        <template x-if="Array.isArray(value)">
                                                            <div class="mb-3">
                                                                <label class="fw-semibold" x-text="key"></label>
                                                                <template x-for="(entry, index) in value" :key="index">
                                                                    <div class="row mb-2 align-items-center">
                                                                        <template x-if="typeof entry === 'object'">
                                                                            <template x-for="(v, subKey) in entry" :key="subKey">
                                                                                <div class="col">
                                                                                    <input
                                                                                        type="text"
                                                                                        class="form-control"
                                                                                        :placeholder="subKey"
                                                                                        :name="`options[${item.id}][data][${key}][${index}][${subKey}]`"
                                                                                        x-model="entry[subKey]">
                                                                                </div>
                                                                            </template>
                                                                        </template>
                                                                        <template x-if="typeof entry !== 'object'">
                                                                            <div class="col">
                                                                                <input
                                                                                    type="text"
                                                                                    class="form-control"
                                                                                    :placeholder="`Value ${index}`"
                                                                                    :name="`options[${item.id}][data][${key}][${index}]`"
                                                                                    x-model="value[index]">
                                                                            </div>
                                                                        </template>
                                                                    </div>
                                                                </template>
                                                                <button type="button" class="btn btn-outline-primary btn-sm"
                                                                    @click="item.data[key].push({})">
                                                                    + Add to <span x-text="key"></span>
                                                                </button>
                                                            </div>
                                                        </template>

                                                        <template x-if="!Array.isArray(value)">
                                                            <div class="mb-2">
                                                                <label class="fw-semibold" x-text="key"></label>
                                                                <input type="text"
                                                                    class="form-control"
                                                                    :name="`options[${item.id}][data][${key}]`"
                                                                    x-model="item.data[key]">
                                                            </div>
                                                        </template>
                                                    </div>
                                                </template>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </template>

                        <button class="btn btn-primary" type="submit">
                            Update All
                        </button>
                    </div>
                </template>
            </form>
        </div>
    </div>
</div>

<script>
    function optionManager() {
        return {
            currentGroup: null,
            groupedOptions: <?php echo json_encode($options->groupBy('group')->map(function ($groupItems) {
                                return $groupItems->map(function ($item) {
                                    return [
                                        'id' => $item->id,
                                        'key' => $item->key,
                                        'value' => $item->value,
                                        'data' => is_array($item->data) ? $item->data : json_decode($item->data),
                                    ];
                                });
                            })) ?>,
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/option/panel.blade.php ENDPATH**/ ?>