<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between">
        <h1><?php echo e(__('Office Equipment Groups')); ?></h1>
        <a href="<?php echo e(route('admin.office-equipment-groups.create')); ?>" class="btn btn-primary mb-3"><?php echo e(__('Create New Group')); ?></a>
    </div>
    <div class="card-body">
        <div class="">

            <table class="table table-striped table-bordered rounded align-middle text-center">
                <thead>
                    <tr>
                        <th><?php echo e(__('Name')); ?></th>
                        <th><?php echo e(__('Description')); ?></th>
                        <th><?php echo e(__('Created By')); ?></th>
                        <th><?php echo e(__('Actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($group->name); ?></td>
                        <td><?php echo e($group->description); ?></td>
                        <td><?php echo e($group->creator->name ?? 'N/A'); ?></td>
                        <td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('office-equipment-group.view')): ?>
                            <a href="<?php echo e(route('admin.office-equipment-groups.show', $group)); ?>" class="btn btn-info btn-sm"><?php echo e(__('View')); ?></a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('office-equipment-group.edit')): ?>
                            <a href="<?php echo e(route('admin.office-equipment-groups.edit', $group)); ?>" class="btn btn-warning btn-sm"><?php echo e(__('Edit')); ?></a>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('office-equipment-group.delete')): ?>
                            <form action="<?php echo e(route('admin.office-equipment-groups.destroy', $group)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm"><?php echo e(__('Delete')); ?></button>
                            </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/office-equipment-groups/index.blade.php ENDPATH**/ ?>