<!-- resources/views/categories/partials/category.blade.php -->
<li class="list-group-item  list-hover-cat-parent">
    <div class="d-flex justify-content-between">
        <div>
            <img class="list-item-image" src="<?php echo e(asset("uploads/$category->image")); ?>" alt="" style="width: 25px; aspect-ratio: 1/1;">
            <?php echo e($category->name); ?>

        </div>
        <div class="d-flex align-items-center gap-3">
            <a class="badge bg-primary badge-pill " href="<?php echo e(route('admin.categories.show' ,$category->id)); ?>">
                <?php echo e(__('details')); ?>

            </a>
            <a class="badge bg-primary badge-pill click-load" href="<?php echo e(route('admin.categories.edit' ,$category->id)); ?>">
                <?php echo e(__('edit')); ?>

            </a>
            <a class="badge bg-primary badge-pill click-load" href="<?php echo e(route('admin.category.attribute.index' ,$category->id)); ?>">
                <?php echo e(__('attribute')); ?>

            </a>
            <?php if($category->children->isEmpty()): ?>
            <a class="badge bg-primary badge-pill click-load" href="<?php echo e(route('admin.product.create' ,['category_id' => $category->id])); ?>">
                <?php echo e(__('create a product')); ?>

            </a>
            <?php endif; ?>

            <form class="m-0 p-0 d-inline-block delete-form" action="<?php echo e(route('admin.categories.destroy' , $category->id)); ?>"  method="post" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this coupon?') ?>');">
                <?php echo method_field('DELETE'); ?>
                <?php echo csrf_field(); ?>
                <button class="badge bg-danger badge-pill border-0">
                    <?php echo e(__('delete')); ?>

                </button>
            </form>
        </div>
    </div>

    <?php if($category->children->isNotEmpty()): ?>

    <ul class="list-group mb-3 mt-3">
        <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $__env->make('pages.admin.categories.partials.categories', ['category' => $child], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
    <?php endif; ?>
</li>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/categories/partials/categories.blade.php ENDPATH**/ ?>