<?php
$idPersian = 'persian_' . $name;
$idGregorian = 'gregorian_' . $name;
$format = $timePicker ? 'YYYY/MM/DD HH:mm' : 'YYYY/MM/DD';
?>

<div class="mb-3">
    <?php if($label): ?>
    <label for="<?php echo e($idPersian); ?>" class="form-label"><?php echo e($label); ?></label>
    <?php endif; ?>

    <input type="text" id="<?php echo e($idPersian); ?>" class="form-control" placeholder="تاریخ <?php echo e($timePicker ? 'و زمان' : 'شمسی'); ?> را انتخاب کنید" autocomplete="off">
    <input type="text" id="<?php echo e($idGregorian); ?>" name="<?php echo e($name); ?>" value="<?php echo e(old($name, $value)); ?>">
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        const options = {
            format: '<?php echo e($format); ?>',
            autoClose: true,
            initialValue: false,
            calendar: {
                persian: {
                    leapYearMode: 'astronomical'
                }
            },
            onSelect: function(unix) {
                const miladiStr = new persianDate(unix)
                    .toCalendar('gregorian')
                    .toLocale('en')
                    .format('<?php echo e($format === "YYYY/MM/DD HH:mm" ? "YYYY-MM-DD HH:mm" : "YYYY-MM-DD"); ?>');
                $('#<?php echo e($idGregorian); ?>').val(miladiStr);
            }
        };

        <?php if($timePicker): ?>
        options.timePicker = {
            enabled: true,
            showSeconds: false,
            scrollEnabled: true
        };
        <?php endif; ?>

        $('#<?php echo e($idPersian); ?>').persianDatepicker(options);

        <?php if (old($name, $value)) : ?>
            const parts = '<?php echo e(old($name, $value)); ?>'.split(/[- :]/);
            const pd = new persianDate().toCalendar('gregorian').toLocale('en')
                .year(parts[0]).month(parts[1]).day(parts[2]);

            <?php if($timePicker): ?>
            pd.hour(parts[3] ?? 0).minute(parts[4] ?? 0);
            <?php endif; ?>

            $('#<?php echo e($idPersian); ?>').persianDatepicker('setDate', pd.valueOf());
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/form/persian-datepicker.blade.php ENDPATH**/ ?>