<div>
    <div class="container pt-10">
        <!-- Breadcrumb -->
        <!--[if BLOCK]><![endif]--><?php if(false): ?>
        <div class="mb-8 flex flex-wrap items-center gap-2 text-sm text-text/60">
            <a href="./index.html" class="flex items-center gap-x-1">
                بلسر
                <div class="i-lucide-chevron-left size-4"></div>
            </a>
            <div>
                <a href="./shop.html" class="flex items-center gap-x-1">سالومون
                    <div class="i-lucide-chevron-left size-4"></div>
                </a>
            </div>
        </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Detail -->
        <div class="mb-16 grid grid-cols-12 gap-4">
            <div class="col-span-12 flex-grow rounded-lg bg-muted px-4 py-6 shadow-md lg:col-span-9">
                <div class="mb-6 grid grid-cols-12 gap-6">
                    <div class="col-span-12 space-y-4 lg:col-span-4 lg:min-w-fit">
                        <!-- Special Countdown -->
                        <!--[if BLOCK]><![endif]--><?php if($product->hasSpecialOffer()): ?>
                        <div class="flex flex-wrap items-center justify-between gap-x-2 font-medium md:justify-center 2xl:justify-between">
                            <div class="text-warning">
                                <?php echo e(__('Special offer')); ?>

                            </div>
                        </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <div>
                            <!-- Desktop Gallery -->
                            <div class="hidden space-y-4 lg:block">
                                <!-- Main image -->
                                <button type="button" data-modal-target="gallery-modal" data-modal-toggle="gallery-modal">
                                    <img src="<?php echo e($product->brand_img); ?>" alt="<?php echo e($product->title); ?>" loading="lazy" class="mx-auto h-full w-full cursor-pointer rounded-xl aspect-square object-cover">
                                </button>
                                <!-- Gallery -->
                                <div class="flex w-full flex-wrap items-center justify-center gap-2 square">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button type="button" data-modal-target="gallery-modal" data-modal-toggle="gallery-modal" class="relative cursor-pointer overflow-hidden rounded-xl border">
                                        <img src="<?php echo e($image->value); ?>" alt="<?php echo e($product->title); ?>" loading="lazy" class="h-16 w-16">
                                    </button>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->


                                    <button type="button" data-modal-target="gallery-modal" data-modal-toggle="gallery-modal" class="relative cursor-pointer overflow-hidden rounded-xl border">
                                        <img src="./assets/images/p1.png" alt="<?php echo e($product->title); ?>" loading="lazy" class="h-16 w-16"><span class="absolute inset-0 flex items-center justify-center backdrop-blur-md">
                                            <div class="i-lucide-ellipsis size-6"></div>
                                        </span>
                                    </button>
                                </div>
                            </div>
                            <!-- Mobile Gallery -->
                            <div class="lg:hidden">
                                <div class="mb-4">
                                    <div class="swiper product-gallery-mobile-swiper swiper-initialized swiper-horizontal swiper-rtl">
                                        <div class="swiper-wrapper" id="swiper-wrapper-0103c411f8d900426" aria-live="polite" style="transition-duration: 0ms; transition-delay: 0ms;">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="swiper-slide">
                                                <img src="<?php echo e($image->value); ?>" alt="<?php echo e($product->title); ?>" class="mx-auto h-[250px] rounded-lg object-cover">
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                                        </div>
                                        <div class="swiper-pagination text-left swiper-pagination-bullets swiper-pagination-horizontal"></div>
                                        <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Mobile Actions ( Favorite, Compare, Share )-->
                        <div class="flex items-center justify-end gap-2 text-text/95 lg:hidden">
                            <button class="icon-btn h-10 w-10" title="Product add to Favorite">
                                <div class="i-lucide-heart size-6"></div>
                            </button>
                            <button class="icon-btn h-10 w-10">
                                <div class="i-lucide-align-horizontal-justify-center size-6"></div>
                            </button>

                            <button class="icon-btn h-10 w-10" data-state="closed" type="button" data-modal-target="share-modal" data-modal-toggle="share-modal">
                                <div class="i-lucide-share-2 size-6"></div>
                            </button>
                        </div>
                    </div>

                    <div class="col-span-12 flex min-h-full flex-col lg:col-span-8">
                        <div class="flex gap-4">
                            <div class="flex-grow">
                                <h1 class="mb-4 text-lg font-semibold">
                                    <?php echo e($product->title); ?>

                                </h1>
                                <div class="mb-6 flex items-center gap-2">
                                    <h2 class="line-clamp-1 text-sm font-light text-text/60">
                                        <?php echo e($product->category->name); ?>

                                    </h2>
                                    <span class="h-px flex-grow bg-secondary"></span>
                                </div>
                                <div class="mb-4 flex items-center gap-4 border-b pb-6 text-sm font-light">
                                    <div class="text-text/95">
                                        <?php echo e(__('code')); ?> : <?php echo e($product->code); ?>

                                    </div>
                                    <span class="h-4 w-px rounded-full bg-secondary"></span>
                                    <div class="cursor-pointer text-primary">
                                        <?php echo e(__('comments')); ?>: <?php echo e($product->comments->count()); ?>

                                    </div>
                                </div>
                            </div>

                            <!-- Desktop Actions ( Favorite, Compare, Share )-->
                            <div class="hidden flex-col items-center gap-2 text-text/95 lg:flex">
                                <div>
                                    <!--[if BLOCK]><![endif]--><?php if(auth()->guard()->check()): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('blesser.like', ['product' => $product]);

$__html = app('livewire')->mount($__name, $__params, 'lw-1967468786-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php if(auth()->guard()->guest()): ?>
                                    <div>
                                        <button data-popover-target="popover-favorite" data-popover-placement="right" type="button" class="icon-btn h-10 w-10" title="Product add to Favorite">
                                            <div class="i-lucide-heart size-6 "></div>
                                        </button>

                                        <div data-popover="" id="popover-favorite" role="tooltip" class="invisible absolute z-10 inline-block rounded-lg border bg-background px-2 py-1 text-sm opacity-0 shadow-sm transition-opacity duration-300" data-popper-placement="right" data-popper-reference-hidden="" data-popper-escaped="" style="position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate(397px, 262px);">
                                            <div class="px-3 py-2">
                                                <p>
                                                    <?php echo e(__('add to favorite')); ?>

                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(false): ?>
                                <div>
                                    <button data-popover-target="popover-compare" data-popover-placement="right" type="button" class="icon-btn h-10 w-10" title="Product add to Favorite">
                                        <div class="i-lucide-align-horizontal-justify-center size-6"></div>
                                    </button>

                                    <div data-popover="" id="popover-compare" role="tooltip" class="invisible absolute z-10 inline-block rounded-lg border bg-background px-2 py-1 text-sm opacity-0 shadow-sm transition-opacity duration-300" data-popper-placement="right" data-popper-reference-hidden="" data-popper-escaped="" style="position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate(397px, 310px);">
                                        <div class="px-3 py-2">
                                            <p>
                                                <?php echo e(__('add to compare')); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <div>
                                    <button data-popover-target="popover-share" data-popover-placement="right" type="button" data-modal-target="share-modal" data-modal-toggle="share-modal" class="icon-btn h-10 w-10" title="Product add to Favorite">
                                        <div class="i-lucide-share-2 size-6"></div>
                                    </button>

                                    <div data-popover="" id="popover-share" role="tooltip" class="invisible absolute z-10 inline-block rounded-lg border bg-background px-2 py-1 text-sm opacity-0 shadow-sm transition-opacity duration-300" data-popper-placement="right" data-popper-reference-hidden="" style="position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate(397px, 358px);">
                                        <div class="px-3 py-2">
                                            <p>
                                                <?php echo e(__('share')); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="flex flex-grow flex-col">
                            <!-- attribute selection -->
                            <div class="mb-8 space-y-4">
                                <div>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $productVariantInputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant_input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <!-- Properties -->
                            <div>
                                <p class="mb-6 font-medium">
                                    <?php echo e(__('product specs')); ?>

                                </p>
                                <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
                                    <!--[if BLOCK]><![endif]--><?php if(isset($product->attribute) && $product->attribute->isNotEmpty()): ?>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $product->attribute->shuffle()->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="space-y-1 rounded-lg bg-background px-4 py-2">
                                        <div class="line-clamp-1 text-xs text-text/60">
                                            <?php echo e($attribute->label); ?>

                                        </div>
                                        <div class="line-clamp-1 text-sm text-text/95">
                                            <?php echo e($attribute->value); ?>

                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="hidden gap-2 md:grid md:grid-cols-2 xl:grid-cols-4">
                    <div class="flex w-full items-center gap-2 rounded-lg border px-2 py-4 text-sm text-text/60">
                        <div class="i-lucide-timer-reset size-6"></div>
                        <?php echo e(__('Seven days return guarantee')); ?>

                    </div>
                    <div class="flex w-full items-center gap-2 rounded-lg border px-2 py-4 text-sm text-text/60">
                        <div class="i-lucide-badge-check size-6"></div>
                        <?php echo e(__('Authenticity guarantee')); ?>

                    </div>
                    <div class="flex w-full items-center gap-2 rounded-lg border px-2 py-4 text-sm text-text/60">
                        <div class="i-lucide-headset size-6"></div>
                        <?php echo e(__('Seven days a week support')); ?>

                    </div>
                    <div class="flex w-full items-center gap-2 rounded-lg border px-2 py-4 text-sm text-text/60">
                        <div class="i-lucide-earth size-6"></div>
                        <?php echo e(__('Shipping across Iran')); ?>

                    </div>
                </div>
            </div>

            <!-- Desktop Add to Cart -->
            <div class="sticky top-36 col-span-3 hidden h-fit rounded-lg bg-muted px-4 py-6 shadow-md lg:block">
                <div class="mb-6 flex justify-between">
                    <div>
                        <div class="flex flex-col gap-1">
                            <!--[if BLOCK]><![endif]--><?php if( $product->off_rate != 0 && $product->off_rate != null): ?>
                            <div class="w-9 rounded-full bg-warning text-center text-sm text-white">
                                <?php echo e($product->off_rate); ?>%
                            </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!--[if BLOCK]><![endif]--><?php if($discountAmount != 0 ): ?>
                            <del class="text-sm text-text/60 xl:text-base">
                                <?php echo e(number_format($price + $discountAmount)); ?>

                            </del>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        </div>
                    </div>
                    <div class="flex items-center gap-x-1">
                        <span class="font-bold xl:text-xl">
                            <?php echo e(number_format($price )); ?>

                        </span>
                        <span class="text-xs text-text/60">
                            <?php echo e(getCurrency()); ?>

                        </span>
                    </div>
                </div>
                <div>
                    <div>
                        <div>
                            <button wire:click="addToCart" class="btn-primary w-full py-2.5 cursor-pointer" aria-label="Add to Cart">
                                <?php echo e(__('add to cart')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Mobile Add to Cart -->
            <div data-onscrollclass="translate-y-1/2" class="fixed inset-x-0 bottom-0 z-20 rounded-t-xl bg-muted px-4 pb-20 pt-4 transition-all duration-300 lg:hidden translate-y-1/2">
                <div>
                    <button wire:click="addToCart" class="btn-primary w-full py-2 cursor-pointer" aria-label="Add to Cart">
                        <?php echo e(__('add to cart')); ?> |
                        <?php echo e($price); ?>

                        <span class="text-xs"> <?php echo e(getCurrency()); ?> </span>
                    </button>
                </div>
            </div>
        </div>

        <div class="mb-16">
            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $sellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="mb-4 flex items-center justify-between rounded-lg bg-muted px-4 py-6 shadow-md  <?php if($seller->id == $selectedSeller): ?> border-1 !border-primary <?php endif; ?> ">
                <div class="flex items-center gap-4">
                    <div class="flex h-16 w-16 items-center justify-center rounded-full bg-background">
                        <img data-scope="shop-profile" onerror="window.app.handleBrokenImage(this)" src="<?php echo e(asset("uploads/$seller->logo ")); ?>" alt="<?php echo e($seller->name); ?>" class="h-10 w-10 rounded-full object-cover">
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-text/95">
                            <?php echo e($seller->name); ?>

                        </h3>
                        <p class="text-xs text-text/60">
                            <?php echo e($seller->description); ?>

                        </p>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-5 ">
                    <div>
                        <?php echo e(__('Inventory')); ?>:
                        <?php echo e($inventory[$seller->id]->inventory); ?>

                    </div>
                    <div>
                        <?php echo e(number_format($inventory[$seller->id]->price)); ?>

                        <span class="text-xs text-text/60">
                            <?php echo e(getCurrency()); ?>

                        </span>
                    </div>
                    <button wire:click="selectSeller(<?php echo e($seller->id); ?>)" class="btn-primary py-2.5 px-4 cursor-pointer" aria-label=" <?php echo e(__('select seller')); ?>">
                        <?php echo e(__('select seller')); ?>

                    </button>
                </div>
            </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <div wire:ignore>
            <?php if (isset($component)) { $__componentOriginalb84431845a664cd19d008bcd7b6e5915 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb84431845a664cd19d008bcd7b6e5915 = $attributes; } ?>
<?php $component = App\View\Components\Blesser\Element\ProductSlider::resolve(['title' => ''.e(__('similar products')).'','link' => '#','category' => $product->category_id] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blesser.element.product-slider'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Blesser\Element\ProductSlider::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb84431845a664cd19d008bcd7b6e5915)): ?>
<?php $attributes = $__attributesOriginalb84431845a664cd19d008bcd7b6e5915; ?>
<?php unset($__attributesOriginalb84431845a664cd19d008bcd7b6e5915); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb84431845a664cd19d008bcd7b6e5915)): ?>
<?php $component = $__componentOriginalb84431845a664cd19d008bcd7b6e5915; ?>
<?php unset($__componentOriginalb84431845a664cd19d008bcd7b6e5915); ?>
<?php endif; ?>
        </div>

        <!-- Information -->

        <div class="rounded-lg bg-muted px-4 py-6 shadow-md">
            <!-- Tabs -->
            <ul class="mb-6 flex justify-between gap-x-2 border-b text-center text-sm font-medium xs:justify-start xs:gap-x-4 xs:text-base">
                <li>
                    <div data-scroll-to="description" class="inline-block cursor-pointer rounded-t-lg border-b-2 border-transparent px-2 pb-2 duration-200 hover:text-primary">
                        <?php echo e(__('description')); ?>

                    </div>
                </li>
                <li>
                    <div data-scroll-to="specs" class="inline-block cursor-pointer rounded-t-lg border-b-2 border-transparent px-2 pb-2 duration-200 hover:text-primary">
                        <?php echo e(__('specs')); ?>

                    </div>
                </li>
                <li>
                    <div data-scroll-to="comment" class="inline-block cursor-pointer rounded-t-lg border-b-2 border-transparent px-2 pb-2 duration-200 hover:text-primary">
                        <?php echo e(__('comments')); ?>

                    </div>
                </li>
            </ul>
            <div class="divide-y divide-border">
                <!-- description -->

                <div class="py-6">
                    <div id="description" class="-translate-y-36"></div>
                    <div class="relative mb-16 w-fit text-2xl font-medium">
                        <?php echo e(__('description')); ?>

                        <span class="absolute right-0 top-10 h-[3px] w-full rounded-full bg-primary"></span>
                    </div>
                    <div data-show-more="">
                        <div data-show-max="450" class="mb-4 max-w-full overflow-hidden" style="max-height: 450px;">
                            <article class="whitespace-pre-line text-justify prose !max-w-full dark:prose-invert [&amp;_a]:text-primary [&amp;_a]:no-underline [&amp;_img]:mx-auto [&amp;_img]:rounded-xl [&amp;_ul]:list-inside">
                                <?php echo e($product->content); ?>

                            </article>
                        </div>
                        <div class="relative flex justify-center">
                            <button data-show-more-button="" type="button" data-drawer-target="description-drawer" data-drawer-show="description-drawer" data-drawer-placement="bottom" class="text-primary duration-300 hover:text-primary/80">
                                <?php echo e(__('show more')); ?>

                            </button>
                        </div>
                    </div>
                </div>
                <!-- Specs -->
                <div class="py-6">
                    <div id="specs" class="-translate-y-60"></div>
                    <div class="relative mb-16 w-fit text-2xl font-medium">
                        <?php echo e(__('specs')); ?>

                        <span class="absolute right-0 top-10 h-[3px] w-full rounded-full bg-primary"></span>
                    </div>

                    <div data-show-more="">
                        <div data-show-max="450" class="prose mb-4 max-w-full overflow-hidden dark:prose-invert" style="max-height: 450px;">
                            <ul class="w-full space-y-6 text-sm">
                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $product->attribute; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li class="grid grid-cols-3 gap-x-2 lg:grid-cols-5">
                                    <div class="col-span-1 text-text/60">
                                        <?php echo e($attribute->label); ?>

                                    </div>
                                    <div class="col-span-2 border-b pb-4 text-text/95 lg:col-span-4">
                                        <ul class="space-y-4">
                                            <li>
                                                <?php echo e($attribute->value); ?>

                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </ul>
                        </div>
                        <div class="relative flex justify-center">
                            <button data-show-more-button="" type="button" data-drawer-target="specs-drawer" data-drawer-show="specs-drawer" data-drawer-placement="bottom" class="text-primary duration-300 hover:text-primary/80">
                                <?php echo e(__('show more')); ?>

                            </button>
                        </div>
                    </div>
                </div>
                <!-- Comments -->
                <?php if (isset($component)) { $__componentOriginal24b43b673a5c8778df91ead3038b0aae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal24b43b673a5c8778df91ead3038b0aae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blesser.element.comment','data' => ['product' => $product]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blesser.element.comment'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['product' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($product)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal24b43b673a5c8778df91ead3038b0aae)): ?>
<?php $attributes = $__attributesOriginal24b43b673a5c8778df91ead3038b0aae; ?>
<?php unset($__attributesOriginal24b43b673a5c8778df91ead3038b0aae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal24b43b673a5c8778df91ead3038b0aae)): ?>
<?php $component = $__componentOriginal24b43b673a5c8778df91ead3038b0aae; ?>
<?php unset($__componentOriginal24b43b673a5c8778df91ead3038b0aae); ?>
<?php endif; ?>
            </div>
        </div>
    </div>


    <!-- Modals -->
    <!-- Share Modal -->
    <?php if (isset($component)) { $__componentOriginal966b0cd2078b997ea2830df116f9235c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal966b0cd2078b997ea2830df116f9235c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blesser.ui.modal','data' => ['id' => 'share-modal']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blesser.ui.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'share-modal']); ?>
         <?php $__env->slot('header', null, []); ?> 
            <div class="flex items-center justify-between">
                <h3 class="md:text-lg">
                    <?php echo e(__('shear with your friend')); ?>

                </h3>

                <button class="text-text/60 duration-300 hover:text-text/95" data-modal-hide="share-modal" type="button">
                    <div class="i-lucide-x size-6"></div>
                    <span class="sr-only">Close menu</span>
                </button>
            </div>
         <?php $__env->endSlot(); ?>

        <div class="flex items-center gap-4">
            <button class="text-primary" data-copy-clipboard="<?php echo e(route('product.details' , $product->slug)); ?>">
                <div class="i-lucide-copy size-6"></div>
                <div class="i-lucide-check hidden size-6"></div>
            </button>
            <div class="w-full">
                <div class="line-clamp-1 w-full select-none rounded-lg border px-4 py-3">
                    <input value="<?php echo e(route('product.details' , $product->slug)); ?>" class="w-full bg-transparent text-left outline-none" readonly="" type="text" />
                </div>
            </div>
        </div>

         <?php $__env->slot('footer', null, []); ?> 
            <div class="flex justify-end">
                <button data-modal-hide="share-modal" type="button" class="btn-warning w-full rounded-lg px-4 py-2 md:w-auto">
                    <span>
                        <?php echo e(__('close')); ?>

                    </span>
                </button>
            </div>
         <?php $__env->endSlot(); ?>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal966b0cd2078b997ea2830df116f9235c)): ?>
<?php $attributes = $__attributesOriginal966b0cd2078b997ea2830df116f9235c; ?>
<?php unset($__attributesOriginal966b0cd2078b997ea2830df116f9235c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal966b0cd2078b997ea2830df116f9235c)): ?>
<?php $component = $__componentOriginal966b0cd2078b997ea2830df116f9235c; ?>
<?php unset($__componentOriginal966b0cd2078b997ea2830df116f9235c); ?>
<?php endif; ?>

    <!-- Gallery Modal -->

    <?php if (isset($component)) { $__componentOriginal966b0cd2078b997ea2830df116f9235c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal966b0cd2078b997ea2830df116f9235c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blesser.ui.modal','data' => ['id' => 'gallery-modal','width' => 'max-w-5xl']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blesser.ui.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'gallery-modal','width' => 'max-w-5xl']); ?>
         <?php $__env->slot('header', null, []); ?> 
            <div class="flex items-center justify-between">
                <h3 class="md:text-lg">
                    <?php echo e($product->title); ?>

                </h3>

                <button class="text-text/60 duration-300 hover:text-text/95" data-modal-hide="gallery-modal" type="button">
                    <div class="i-lucide-x size-6"></div>

                    <span class="sr-only">Close menu</span>
                </button>
            </div>
         <?php $__env->endSlot(); ?>

        <div class="flex flex-col gap-4">
            <div>
                <div class="swiper product-gallery-swiper">
                    <div class="swiper-wrapper">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <img src="<?php echo e($image->value); ?>" alt="<?php echo e($product->title); ?>" class="mx-auto min-h-[500px] min-w-[500px]" loading="lazy" />
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="swiper-pagination"></div>
                    <div class="swiper-button-next main-slider-nav-button"></div>
                    <div class="swiper-button-prev main-slider-nav-button"></div>
                </div>
            </div>
        </div>


     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal966b0cd2078b997ea2830df116f9235c)): ?>
<?php $attributes = $__attributesOriginal966b0cd2078b997ea2830df116f9235c; ?>
<?php unset($__attributesOriginal966b0cd2078b997ea2830df116f9235c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal966b0cd2078b997ea2830df116f9235c)): ?>
<?php $component = $__componentOriginal966b0cd2078b997ea2830df116f9235c; ?>
<?php unset($__componentOriginal966b0cd2078b997ea2830df116f9235c); ?>
<?php endif; ?>

    <!-- Drawers -->

    <!-- Description Drawer -->
    <?php if (isset($component)) { $__componentOriginal474e1857641dbf7f25eee58a3102a32d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal474e1857641dbf7f25eee58a3102a32d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blesser.ui.drawer','data' => ['id' => 'description-drawer']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blesser.ui.drawer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'description-drawer']); ?>
        <div class="grow overflow-y-auto px-4">
            <article class="container prose !max-w-xl dark:prose-invert [&_a]:text-primary [&_a]:no-underline [&_img]:mx-auto [&_img]:rounded-xl [&_ul]:list-inside">
                <?php echo e($product->content); ?>

            </article>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal474e1857641dbf7f25eee58a3102a32d)): ?>
<?php $attributes = $__attributesOriginal474e1857641dbf7f25eee58a3102a32d; ?>
<?php unset($__attributesOriginal474e1857641dbf7f25eee58a3102a32d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal474e1857641dbf7f25eee58a3102a32d)): ?>
<?php $component = $__componentOriginal474e1857641dbf7f25eee58a3102a32d; ?>
<?php unset($__componentOriginal474e1857641dbf7f25eee58a3102a32d); ?>
<?php endif; ?>

    <!-- Specs Drawer -->
    <?php if (isset($component)) { $__componentOriginal474e1857641dbf7f25eee58a3102a32d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal474e1857641dbf7f25eee58a3102a32d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blesser.ui.drawer','data' => ['id' => 'specs-drawer']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blesser.ui.drawer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'specs-drawer']); ?>
        <div class="grow overflow-y-auto pb-20">
            <ul class="container w-full space-y-6 text-sm">
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $product->attribute; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <li class="grid grid-cols-3 gap-x-2 lg:grid-cols-5">
                    <div class="col-span-1 text-text/60">
                        <?php echo e($attribute->label); ?>

                    </div>
                    <div class="col-span-2 border-b pb-4 text-text/95 lg:col-span-4">
                        <ul class="space-y-4">
                            <li>
                                <?php echo e($attribute->value); ?>

                            </li>
                        </ul>
                    </div>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </ul>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal474e1857641dbf7f25eee58a3102a32d)): ?>
<?php $attributes = $__attributesOriginal474e1857641dbf7f25eee58a3102a32d; ?>
<?php unset($__attributesOriginal474e1857641dbf7f25eee58a3102a32d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal474e1857641dbf7f25eee58a3102a32d)): ?>
<?php $component = $__componentOriginal474e1857641dbf7f25eee58a3102a32d; ?>
<?php unset($__componentOriginal474e1857641dbf7f25eee58a3102a32d); ?>
<?php endif; ?>

    <!-- comments List Drawer -->
    <?php if (isset($component)) { $__componentOriginal474e1857641dbf7f25eee58a3102a32d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal474e1857641dbf7f25eee58a3102a32d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blesser.ui.drawer','data' => ['id' => 'comment-list-drawer']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blesser.ui.drawer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'comment-list-drawer']); ?>
        <div class="grow overflow-y-auto pb-10">
            <ul class="space-y-6 px-4">
                <li>
                    <div class="flex h-64 flex-col rounded-lg border">
                        <div aria-controls="comment-detail-drawer" data-drawer-show="comment-detail-drawer" data-drawer-placement="bottom" data-drawer-target="comment-detail-drawer" type="button" class="flex-grow cursor-pointer px-4 pt-6">
                            <div class="mb-4 flex items-center gap-2">
                                <div class="truncate">کاربر بلسر</div>
                                <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                            </div>
                            <div class="mb-4 flex items-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                پیشنهاد نمیکنم
                            </div>
                            <div class="space-y-2">
                                <h5 class="truncate text-sm leading-relaxed">عنوان تست تست</h5>
                                <p class="line-clamp-2 text-sm leading-relaxed text-text/80">متن تست متن تست متن تست متن تست متن تست</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between px-4 pb-6">
                            <div class="flex items-center gap-6">
                                <button class="relative flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                                    <span class="i-lucide-thumbs-up size-6"></span>

                                    <span class="absolute -right-2 top-6 text-sm"> 32 </span>
                                </button>
                                <button class="relative flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                                    <span class="i-lucide-thumbs-down size-6"></span>
                                    <span class="absolute -right-2 top-6 text-sm"> 76 </span>
                                </button>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="text-xs text-text/60">شنبه 4 خرداد</div>
                            </div>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="flex h-64 flex-col rounded-lg border">
                        <div aria-controls="comment-detail-drawer" data-drawer-show="comment-detail-drawer" data-drawer-placement="bottom" data-drawer-target="comment-detail-drawer" type="button" class="flex-grow cursor-pointer px-4 pt-6">
                            <div class="mb-4 flex items-center gap-2">
                                <div class="truncate">کاربر بلسر</div>
                                <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                            </div>
                            <div class="mb-4 flex items-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                پیشنهاد نمیکنم
                            </div>
                            <div class="space-y-2">
                                <h5 class="truncate text-sm leading-relaxed">عنوان تست تست</h5>
                                <p class="line-clamp-2 text-sm leading-relaxed text-text/80">متن تست متن تست متن تست متن تست متن تست</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between px-4 pb-6">
                            <div class="flex items-center gap-6">
                                <button class="relative flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                                    <span class="i-lucide-thumbs-up size-6"></span>

                                    <span class="absolute -right-2 top-6 text-sm"> 32 </span>
                                </button>
                                <button class="relative flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                                    <span class="i-lucide-thumbs-down size-6"></span>
                                    <span class="absolute -right-2 top-6 text-sm"> 76 </span>
                                </button>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="text-xs text-text/60">شنبه 4 خرداد</div>
                            </div>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="flex h-64 flex-col rounded-lg border">
                        <div aria-controls="comment-detail-drawer" data-drawer-show="comment-detail-drawer" data-drawer-placement="bottom" data-drawer-target="comment-detail-drawer" type="button" class="flex-grow cursor-pointer px-4 pt-6">
                            <div class="mb-4 flex items-center gap-2">
                                <div class="truncate">کاربر بلسر</div>
                                <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                            </div>
                            <div class="mb-4 flex items-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                پیشنهاد نمیکنم
                            </div>
                            <div class="space-y-2">
                                <h5 class="truncate text-sm leading-relaxed">عنوان تست تست</h5>
                                <p class="line-clamp-2 text-sm leading-relaxed text-text/80">متن تست متن تست متن تست متن تست متن تست</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between px-4 pb-6">
                            <div class="flex items-center gap-6">
                                <button class="relative flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                                    <span class="i-lucide-thumbs-up size-6"></span>

                                    <span class="absolute -right-2 top-6 text-sm"> 32 </span>
                                </button>
                                <button class="relative flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                                    <span class="i-lucide-thumbs-down size-6"></span>
                                    <span class="absolute -right-2 top-6 text-sm"> 76 </span>
                                </button>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="text-xs text-text/60">شنبه 4 خرداد</div>
                            </div>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="flex h-64 flex-col rounded-lg border">
                        <div aria-controls="comment-detail-drawer" data-drawer-show="comment-detail-drawer" data-drawer-placement="bottom" data-drawer-target="comment-detail-drawer" type="button" class="flex-grow cursor-pointer px-4 pt-6">
                            <div class="mb-4 flex items-center gap-2">
                                <div class="truncate">کاربر بلسر</div>
                                <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                            </div>
                            <div class="mb-4 flex items-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                پیشنهاد نمیکنم
                            </div>
                            <div class="space-y-2">
                                <h5 class="truncate text-sm leading-relaxed">عنوان تست تست</h5>
                                <p class="line-clamp-2 text-sm leading-relaxed text-text/80">متن تست متن تست متن تست متن تست متن تست</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between px-4 pb-6">
                            <div class="flex items-center gap-6">
                                <button class="relative flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                                    <span class="i-lucide-thumbs-up size-6"></span>

                                    <span class="absolute -right-2 top-6 text-sm"> 32 </span>
                                </button>
                                <button class="relative flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                                    <span class="i-lucide-thumbs-down size-6"></span>
                                    <span class="absolute -right-2 top-6 text-sm"> 76 </span>
                                </button>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="text-xs text-text/60">شنبه 4 خرداد</div>
                            </div>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal474e1857641dbf7f25eee58a3102a32d)): ?>
<?php $attributes = $__attributesOriginal474e1857641dbf7f25eee58a3102a32d; ?>
<?php unset($__attributesOriginal474e1857641dbf7f25eee58a3102a32d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal474e1857641dbf7f25eee58a3102a32d)): ?>
<?php $component = $__componentOriginal474e1857641dbf7f25eee58a3102a32d; ?>
<?php unset($__componentOriginal474e1857641dbf7f25eee58a3102a32d); ?>
<?php endif; ?>

    <!-- Comment Detail Drawer -->
    <?php if (isset($component)) { $__componentOriginal474e1857641dbf7f25eee58a3102a32d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal474e1857641dbf7f25eee58a3102a32d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blesser.ui.drawer','data' => ['id' => 'comment-detail-drawer']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blesser.ui.drawer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'comment-detail-drawer']); ?>
        <div class="grow overflow-y-auto pb-10">
            <!-- Detail -->
            <div class="mb-6 px-4 py-2">
                <div class="mb-2 flex items-center gap-2">
                    <div>کاربر بلسر</div>
                    <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                    <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                </div>

                <div class="mb-4 leading-relaxed xl:text-lg">عنوان تست</div>
                <div class="mb-6 flex items-center gap-x-4 border-b pb-6">
                    <div class="flex items-center gap-x-2 text-warning">
                        <div class="i-lucide-thumbs-down size-6"></div>
                        پیشنهاد نمیکنم
                    </div>
                </div>
                <div class="mb-6 border-b pb-6">
                    <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                </div>
                <div class="flex items-center justify-end gap-4">
                    <div class="text-xs text-text/60 xs:text-sm">آیا این دیدگاه برایتان مفید بود؟</div>
                    <button class="flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                        <span class="text-sm"> 32 </span>

                        <span class="i-lucide-thumbs-up size-6"></span>
                    </button>
                    <button class="flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                        <span class="text-sm"> 76 </span>
                        <span class="i-lucide-thumbs-down size-6"></span>
                    </button>
                </div>
            </div>
            <!-- Submit Reply-->
            <form class="mb-6 grid grid-cols-2 gap-4 px-4">
                <div class="lg:text-lg">ثبت پاسخ</div>
                <div class="col-span-2">
                    <label for="reply" class="sr-only"> متن پاسخ </label>
                    <textarea rows="3" placeholder="متن پاسخ" type="text" id="reply" class="mb-2 w-full rounded-lg border bg-transparent px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2"></textarea>
                    <!--                                            <div class="text-warning h-5 text-sm">-->
                    <!--                                                                                    این فیلد الزامی می باشد-->
                    <!--                                            </div>-->
                </div>

                <div class="col-span-2 flex justify-end">
                    <button class="btn-primary px-4 py-2">ثبت پاسخ</button>
                </div>
            </form>
            <!-- Replies -->
            <div class="px-4">
                <p class="mb-8 text-lg font-medium">پاسخ ها ( 4 )</p>
                <ul class="space-y-4">
                    <li>
                        <div>
                            <div class="mb-8 flex items-center gap-2">
                                <div>کاربر بلسر</div>
                                <div class="rounded-full bg-primary/10 px-4 py-1 text-sm text-primary">فروشنده</div>
                                <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                            </div>

                            <div class="border-b pb-6">
                                <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div>
                            <div class="mb-8 flex items-center gap-2">
                                <div>کاربر بلسر</div>
                                <div class="rounded-full bg-primary/10 px-4 py-1 text-sm text-primary">فروشنده</div>
                                <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                            </div>

                            <div class="border-b pb-6">
                                <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div>
                            <div class="mb-8 flex items-center gap-2">
                                <div>کاربر بلسر</div>
                                <div class="rounded-full bg-primary/10 px-4 py-1 text-sm text-primary">فروشنده</div>
                                <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                            </div>

                            <div class="border-b pb-6">
                                <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div>
                            <div class="mb-8 flex items-center gap-2">
                                <div>کاربر بلسر</div>
                                <div class="rounded-full bg-primary/10 px-4 py-1 text-sm text-primary">فروشنده</div>
                                <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                            </div>

                            <div class="border-b pb-6">
                                <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal474e1857641dbf7f25eee58a3102a32d)): ?>
<?php $attributes = $__attributesOriginal474e1857641dbf7f25eee58a3102a32d; ?>
<?php unset($__attributesOriginal474e1857641dbf7f25eee58a3102a32d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal474e1857641dbf7f25eee58a3102a32d)): ?>
<?php $component = $__componentOriginal474e1857641dbf7f25eee58a3102a32d; ?>
<?php unset($__componentOriginal474e1857641dbf7f25eee58a3102a32d); ?>
<?php endif; ?>
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/livewire/blesser/product-details.blade.php ENDPATH**/ ?>