<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([ 'role' => null, 'permissions' => []]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([ 'role' => null, 'permissions' => []]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
$isEdit = isset($role) && $role->exists;
?>

<form action="<?php echo e($isEdit ? route('admin.settings.role.update' , $role->id ) : route('admin.settings.role.store')); ?>" method="POST">
    <?php echo csrf_field(); ?>

    <?php if($isEdit): ?>
    <?php echo method_field('PATCH'); ?>
    <?php endif; ?>

    <div class="mb-3">
        <label for="name" class="form-label"><?php echo e(__('Role Name')); ?></label>
        <input type="text" name="name" class="form-control" value="<?php echo e(old('name', $role->name ?? '')); ?>" required>
    </div>

    <div class="mb-3">
        <label class="form-label"><?php echo e(__('Permissions')); ?></label>
        <div class="row">
            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-4">
                <div class="form-check">
                    <input id="permission-<?php echo e($permission->id); ?>" class="form-check-input" type="checkbox"
                        name="permissions[]" value="<?php echo e($permission->name); ?>"
                        <?php echo e(isset($role) && $role->hasPermissionTo($permission->name) ? 'checked' : ''); ?>>
                    <label class="form-check-label cursor-pointer" for="permission-<?php echo e($permission->id); ?>"><?php echo e($permission->name); ?></label>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
</form>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/syndron/form/role-form.blade.php ENDPATH**/ ?>