<header class="fixed inset-x-0 top-0 z-30 bg-muted">
    <?php if(auth()->guard()->check()): ?>
    <?php if (\Illuminate\Support\Facades\Blade::check('hasrole', ['Admin' ,'Administrator'])): ?>
    <!-- admin login -->
    <div class="flex justify-between p-3">
        <div>
            <a class="flex gap-2 " href="<?php echo e(route('admin.dashboard')); ?>">
                <i class="i-lucide-user-round border-3 dark:border-white border-full"></i>
                <?php echo e(__("Admin Dashboard")); ?>

            </a>
        </div>
        <div>

        </div>
    </div>
    <?php endif; ?>
    <?php endif; ?>

    <?php if(options('ad-header-banner')->isNotEmpty()): ?>
    <!-- Ad Banner -->
    <div class="hidden lg:block">
        <img src="<?php echo e(asset('uploads/'.options('ad-header-banner')->first()->value ?? '')); ?>" alt="ad gif" class="inline-block w-full object-cover" />
    </div>
    <?php endif; ?>

    <!-- Desktop -->
    <div class="hidden lg:block">
        <!-- Top -->
        <div class="container relative z-30 flex items-center justify-between gap-6 bg-muted py-4">
            <!-- Logo -->
            <a href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(asset('uploads/'.getSiteLogo())); ?>" alt="<?php echo e(getSiteName()); ?>" class="h-13" />
            </a>
            <!-- Search Wrapper -->
            <div class="flex-grow">
                <div class="relative">
                    <div id="desktopSearchInputWrapper" class="group relative z-20 flex items-center overflow-hidden rounded-lg border bg-background pr-2 duration-150">
                        <div class="i-carbon-search h-6 w-6 text-text/60"></div>
                        <form action="<?php echo e(route('shop')); ?>" class="h-12 w-full">
                            <label for="desktopSearchInput" class="sr-only"><?php echo e(__('search')); ?></label>
                            <input id="desktopSearchInput" name="search" onfocus="desktopSearchFocus()" onkeyup="desktopSearchOnType(event)" type="text" placeholder="<?php echo e(__('search')); ?>" class="h-full w-full bg-transparent px-2 outline-none placeholder:text-sm placeholder:text-text/60 placeholder:duration-200 group-focus-within:placeholder:-translate-x-2" />
                        </form>

                        <button id="desktopSearchClearButton" onclick="desktopSearchClearValue()" class="ml-2 hidden h-6 w-6 items-center justify-center rounded-lg border bg-muted p-px text-text/60 duration-200 hover:border-primary hover:bg-background">
                            <span class="i-lucide-x h-4 w-4"></span>
                        </button>
                    </div>
                    <?php if(false): ?>
                    <!-- Result Drop down -->
                    <div id="desktopSearchResult" class="absolute left-0 top-16 z-20 hidden w-full space-y-8 rounded-lg bg-muted p-4">
                        <!-- Product Result -->
                        <div class="swiper search-result-slider">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <a href="./product-detail.html" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                                        <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" class="h-20 w-20 rounded-lg object-cover" />
                                        <p class="line-clamp-2 text-text/95">نایک زوم پگاسوس توربو مشکی</p>
                                    </a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="./product-detail.html" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                                        <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" class="h-20 w-20 rounded-lg object-cover" />
                                        <p class="line-clamp-2 text-text/95">نایک زوم پگاسوس توربو مشکی</p>
                                    </a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="./product-detail.html" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                                        <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" class="h-20 w-20 rounded-lg object-cover" />
                                        <p class="line-clamp-2 text-text/95">نایک زوم پگاسوس توربو مشکی</p>
                                    </a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="./product-detail.html" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                                        <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" class="h-20 w-20 rounded-lg object-cover" />
                                        <p class="line-clamp-2 text-text/95">نایک زوم پگاسوس توربو مشکی</p>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!-- Brand Result -->
                        <ul class="space-y-2">
                            <li>
                                <a href="./shop.html" class="flex items-center gap-2 py-2 duration-200 hover:text-primary">
                                    برند نایک
                                    <span class="i-ic-outline-arrow-outward"></span>
                                </a>
                            </li>
                            <li>
                                <a href="./shop.html" class="flex items-center gap-2 py-2 duration-200 hover:text-primary">
                                    برند نیو بالانس
                                    <span class="i-ic-outline-arrow-outward"></span>
                                </a>
                            </li>
                        </ul>
                        <!-- Search History-->
                        <div class="space-y-2">
                            <div class="flex items-center gap-6">
                                <div>جستجوهای اخیر شما</div>
                                <button class="flex items-center gap-2 text-sm text-warning duration-200 hover:text-warning/80">
                                    حذف همه
                                    <i class="i-lucide-trash size-5"></i>
                                </button>
                            </div>

                            <div class="flex flex-wrap gap-4 pt-3">
                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                            </div>
                        </div>
                        <!-- Popular Search -->
                        <div class="space-y-2">
                            <div>جستجوهای پرتکرار</div>
                            <div class="flex flex-wrap gap-4 pt-3">
                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                                <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>

                <div onclick="desktopSearchUnFocus()" id="desktopSearchResultOverlay" class="relative z-10 hidden">
                    <div class="fixed inset-0 bg-black/40"></div>
                </div>
            </div>

            <!-- Account, Cart, Theme -->
            <div class="flex items-center gap-2">
                <!-- Account Logged in -->
                <?php if(auth()->guard()->check()): ?>
                <div>
                    <button type="button" data-dropdown-toggle="desktopAccountDropdown" class="icon-btn h-10 w-10">
                        <div class="i-lucide-user-round h-6 w-6"></div>
                    </button>

                    <!-- Dropdown menu -->
                    <div id="desktopAccountDropdown" class="z-10 hidden w-60 rounded-lg border bg-muted shadow">
                        <ul class="flex flex-col justify-between divide-y">
                            <!-- user -->
                            <li class="group">
                                <a href="<?php echo e(route('user.dashboard')); ?>" class="flex items-center justify-between px-5 py-4 transition-all group-hover:text-primary">
                                    <div class="flex items-center gap-x-3">
                                        <img class="h-8 w-8" src="/assets/themes/blesser/images/user.png" alt="Profile" />
                                        <p class="w-32 overflow-hidden font-semibold">
                                            <?php echo e(auth()->user()->phone ?? auth()->user()->name ?? ''); ?>

                                        </p>
                                    </div>
                                    <div class="i-lucide-chevron-left min-w-fit text-text/60 group-hover:text-primary"></div>
                                </a>
                            </li>
                            <!-- order -->
                            <li class="group">
                                <a href="<?php echo e(route('user.dashboard' , ['tab'=>'order'])); ?>" class="flex items-center justify-between px-5 py-4 transition-all group-hover:text-primary">
                                    <div class="flex items-center gap-x-3">
                                        <svg class="i-mingcute-shopping-bag-3-line h-6 w-6 text-text/70 group-hover:text-primary"></svg>
                                        <p>
                                            <?php echo e(__('Orders')); ?>

                                        </p>
                                    </div>
                                    <svg class="i-lucide-chevron-left text-text/60 group-hover:text-primary"></svg>
                                </a>
                            </li>
                            <!-- favorite -->
                            <li class="group">
                                <a href="<?php echo e(route('user.dashboard' , ['tab'=>'favorite'])); ?>" class="flex items-center justify-between px-5 py-4 transition-all group-hover:text-primary">
                                    <div class="flex items-center gap-x-3">
                                        <svg class="i-ic-baseline-favorite-border h-6 w-6 text-text/70 group-hover:text-primary"></svg>
                                        <p>
                                            <?php echo e(__('Favorites')); ?>

                                        </p>
                                    </div>
                                    <svg class="i-lucide-chevron-left text-text/60 group-hover:text-primary"></svg>
                                </a>
                            </li>
                            <!-- recent searches -->
                            <li class="group">
                                <a href="<?php echo e(route('user.dashboard' , parameters: ['tab'=>'recent'])); ?>" class="flex items-center justify-between px-5 py-4 transition-all group-hover:text-primary">
                                    <div class="flex items-center gap-x-3">
                                        <svg class="i-lucide-mouse-pointer-click h-6 w-6 text-text/70 group-hover:text-primary"></svg>
                                        <p> <?php echo e(__('Recents')); ?> </p>
                                    </div>
                                    <svg class="i-lucide-chevron-left text-text/60 group-hover:text-primary"></svg>
                                </a>
                            </li>
                            <!-- exit -->
                            <li>
                                <a href="<?php echo e(route('logout')); ?>" class="my-1 flex items-center justify-between px-5 py-3 text-warning duration-150 hover:bg-warning/10">
                                    <div class="flex items-center gap-x-3">
                                        <svg class="i-mingcute-exit-line h-6 w-6"></svg>
                                        <p><?php echo e(__('Logout')); ?></p>
                                    </div>
                                    <svg class="i-lucide-chevron-left"></svg>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <?php endif; ?>
                <?php if(auth()->guard()->guest()): ?>
                <!-- Account Logged out -->
                <div>
                    <a href="<?php echo e(route('authentication')); ?>"
                        class="h-10 flex items-center gap-2 border px-4 rounded-lg text-text/80 hover:bg-background duration-200 ">
                        <div class="i-lucide-user-round w-6 h-6"></div>
                        <?php echo e(__('Login / Register')); ?>

                    </a>
                </div>
                <?php endif; ?>
                <!-- Favorite -->
                <div>
                    <a href="<?php echo e(route('user.dashboard' , ['tab' => 'favorite'])); ?>" class="icon-btn relative h-10 w-10 border-primary">
                        <div class="i-lucide-heart h-6 w-6"></div>
                    </a>
                </div>

                <?php if(false): ?>
                <!-- Compare -->
                <div>
                    <button data-dropdown-toggle="desktopCompareDropdown" class="icon-btn relative h-10 w-10 border-primary">
                        <div class="i-lucide-align-horizontal-justify-center h-6 w-6"></div>
                        <div class="absolute -right-1.5 -top-2.5 h-5 w-5 items-center justify-center rounded-full bg-primary-btn text-center text-sm leading-6 text-white">3</div>
                    </button>

                    <!-- Dropdown Shopping -->

                    <div id="desktopCompareDropdown" class="left-10 z-10 !ml-5 hidden w-[420px] rounded-lg border bg-muted shadow">
                        <div>
                            <div class="flex items-center justify-between px-4 pb-2 pt-3">
                                <div>لیست مقایسه</div>
                                <button class="btn-warning px-4 py-2 text-sm">حذف همه</button>
                            </div>
                            <div class="h-60">
                                <ul class="h-full space-y-2 divide-y overflow-y-auto p-5 pl-2">
                                    <li>
                                        <div class="flex gap-x-2 py-5">
                                            <div class="relative min-w-fit">
                                                <a href="./product-detail.html">
                                                    <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" loading="lazy" class="h-25 w-25 rounded-3xl" />
                                                </a>
                                                <button class="absolute -top-2 right-0 rounded-lg border bg-muted duration-200 hover:bg-background">
                                                    <div class="i-lucide-trash m-2 h-4 w-4 text-warning"></div>
                                                </button>
                                            </div>
                                            <div class="w-full space-y-4">
                                                <a href="./product-detail.html" class="line-clamp-2 text-text">نایک زوم پگاسوس توربو مشکی</a>
                                                <div class="flex items-center justify-between gap-x-2">
                                                    <div class="flex items-center gap-x-2 text-primary"><span class="text-lg font-bold">900,000</span><span class="text-sm">تومان</span></div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="flex gap-x-2 py-5">
                                            <div class="relative min-w-fit">
                                                <a href="./product-detail.html">
                                                    <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" loading="lazy" class="h-25 w-25 rounded-3xl" />
                                                </a>
                                                <button class="absolute -top-2 right-0 rounded-lg border bg-muted duration-200 hover:bg-background">
                                                    <div class="i-lucide-trash m-2 h-4 w-4 text-warning"></div>
                                                </button>
                                            </div>
                                            <div class="w-full space-y-4">
                                                <a href="./product-detail.html" class="line-clamp-2 text-text">نایک زوم پگاسوس توربو مشکی</a>
                                                <div class="flex items-center justify-between gap-x-2">
                                                    <div class="flex items-center gap-x-2 text-primary"><span class="text-lg font-bold">900,000</span><span class="text-sm">تومان</span></div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="flex gap-x-2 py-5">
                                            <div class="relative min-w-fit">
                                                <a href="./product-detail.html">
                                                    <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" loading="lazy" class="h-25 w-25 rounded-3xl" />
                                                </a>
                                                <button class="absolute -top-2 right-0 rounded-lg border bg-muted duration-200 hover:bg-background">
                                                    <div class="i-lucide-trash m-2 h-4 w-4 text-warning"></div>
                                                </button>
                                            </div>
                                            <div class="w-full space-y-4">
                                                <a href="./product-detail.html" class="line-clamp-2 text-text">نایک زوم پگاسوس توربو مشکی</a>
                                                <div class="flex items-center justify-between gap-x-2">
                                                    <div class="flex items-center gap-x-2 text-primary"><span class="text-lg font-bold">900,000</span><span class="text-sm">تومان</span></div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="border-t p-2">
                                <a href="./compare.html" class="btn-primary block w-full py-2"> نمایش نتیجه </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Cart -->
                <div>
                    <a href="<?php echo e(route('cart.index')); ?>" class="icon-btn relative h-10 w-10 border-primary">
                        <span class="i-lucide-shopping-cart h-6 w-6"></span>
                        <span class="absolute -right-1.5 -top-2.5 h-5 w-5 items-center justify-center rounded-full bg-primary-btn text-center text-sm leading-6 text-white">
                            <?php echo e(app(\App\Services\Models\CartService::class)->items()->count()); ?>

                        </span>
                    </a>
                    <?php if(false): ?>
                    <button data-dropdown-toggle="desktopShoppingDropdown" class="icon-btn relative h-10 w-10 border-primary">
                        <span class="i-lucide-shopping-cart h-6 w-6"></span>
                        <span class="absolute -right-1.5 -top-2.5 h-5 w-5 items-center justify-center rounded-full bg-primary-btn text-center text-sm leading-6 text-white"> 4 </span>
                    </button>

                    <!-- Dropdown Shopping -->

                    <div id="desktopShoppingDropdown" class="left-10 z-10 !ml-5 hidden w-[420px] rounded-lg border bg-muted shadow">
                        <div class="flex flex-col justify-between text-sm">
                            <!-- header -->
                            <div class="flex justify-between px-5 py-4">
                                <div>2 مورد</div>
                                <a href="./checkout-cart.html" class="flex items-center text-primary duration-200 hover:text-primary/80">
                                    <p>مشاهده سبد خرید</p>
                                    <div class="i-lucide-chevron-left"></div>
                                </a>
                            </div>
                            <!-- Products -->
                            <ul class="max-h-60 divide-y overflow-y-auto p-5">
                                <!-- product1 -->
                                <li class="flex gap-x-3 pb-5 pt-8">
                                    <!-- Image -->
                                    <div class="relative min-w-fit">
                                        <button class="absolute -top-2 right-0 rounded-lg border bg-muted duration-200 hover:bg-background">
                                            <div class="i-lucide-trash m-2 h-4 w-4 text-warning"></div>
                                        </button>
                                        <a href="./product-detail.html">
                                            <img class="h-[120px] w-[120px] rounded-2xl" src="/assets/themes/blesser/images/p1.png" alt="Blesser" />
                                        </a>
                                    </div>
                                    <!-- Information -->
                                    <div class="flex w-full flex-col">
                                        <a href="./product-detail.html" class="line-clamp-2 h-10"> کفش نیوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalance </a>
                                        <div class="flex items-center gap-x-4 pt-3 text-text/80">
                                            <p>تعداد : 1</p>
                                            <div class="h-3 w-0.5 bg-secondary"></div>
                                            <p>سایز : 44</p>
                                        </div>
                                        <div class="flex items-center justify-between gap-x-5 py-3">
                                            <!-- price -->
                                            <div class="flex items-center gap-x-2">
                                                <div class="text-lg font-medium text-primary">1,300,000,000</div>
                                                <p class="text-sm text-primary">تومان</p>
                                            </div>
                                            <!-- Quantity -->

                                            <div class="flex h-10 w-24 items-center justify-between rounded-lg border px-2 py-1">
                                                <button type="button" class="i-lucide-plus size-8 text-success"></button>
                                                <input value="1" disabled="" type="number" class="flex h-5 w-full grow select-none items-center justify-center bg-transparent text-center text-sm outline-none" />
                                                <button type="button" class="i-lucide-minus size-8 text-warning"></button>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="flex gap-x-3 pb-5 pt-8">
                                    <!-- Image -->
                                    <div class="relative min-w-fit">
                                        <button class="absolute -top-2 right-0 rounded-lg border bg-muted duration-200 hover:bg-background">
                                            <div class="i-lucide-trash m-2 h-4 w-4 text-warning"></div>
                                        </button>
                                        <a href="./product-detail.html">
                                            <img class="h-[120px] w-[120px] rounded-2xl" src="/assets/themes/blesser/images/p1.png" alt="Blesser" />
                                        </a>
                                    </div>
                                    <!-- Information -->
                                    <div class="flex w-full flex-col">
                                        <a href="./product-detail.html" class="line-clamp-2 h-10"> کفش نیوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalance </a>
                                        <div class="flex items-center gap-x-4 pt-3 text-text/80">
                                            <p>تعداد : 1</p>
                                            <div class="h-3 w-0.5 bg-secondary"></div>
                                            <p>سایز : 44</p>
                                        </div>
                                        <div class="flex items-center justify-between gap-x-5 py-3">
                                            <!-- price -->
                                            <div class="flex items-center gap-x-2">
                                                <div class="text-lg font-medium text-primary">1,300,000,000</div>
                                                <p class="text-sm text-primary">تومان</p>
                                            </div>
                                            <!-- Quantity -->

                                            <div class="flex h-10 w-24 items-center justify-between rounded-lg border px-2 py-1">
                                                <button type="button" class="i-lucide-plus size-8 text-success"></button>
                                                <input value="1" disabled="" type="number" class="flex h-5 w-full grow select-none items-center justify-center bg-transparent text-center text-sm outline-none" />
                                                <button type="button" class="i-lucide-minus size-8 text-warning"></button>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="flex gap-x-3 pb-5 pt-8">
                                    <!-- Image -->
                                    <div class="relative min-w-fit">
                                        <button class="absolute -top-2 right-0 rounded-lg border bg-muted duration-200 hover:bg-background">
                                            <div class="i-lucide-trash m-2 h-4 w-4 text-warning"></div>
                                        </button>
                                        <a href="./product-detail.html">
                                            <img class="h-[120px] w-[120px] rounded-2xl" src="/assets/themes/blesser/images/p1.png" alt="Blesser" />
                                        </a>
                                    </div>
                                    <!-- Information -->
                                    <div class="flex w-full flex-col">
                                        <a href="./product-detail.html" class="line-clamp-2 h-10"> کفش نیوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalanceوبالانس NewBalance </a>
                                        <div class="flex items-center gap-x-4 pt-3 text-text/80">
                                            <p>تعداد : 1</p>
                                            <div class="h-3 w-0.5 bg-secondary"></div>
                                            <p>سایز : 44</p>
                                        </div>
                                        <div class="flex items-center justify-between gap-x-5 py-3">
                                            <!-- price -->
                                            <div class="flex items-center gap-x-2">
                                                <div class="text-lg font-medium text-primary">1,300,000,000</div>
                                                <p class="text-sm text-primary">تومان</p>
                                            </div>
                                            <!-- Quantity -->

                                            <div class="flex h-10 w-24 items-center justify-between rounded-lg border px-2 py-1">
                                                <button type="button" class="i-lucide-plus size-8 text-success"></button>
                                                <input value="1" disabled="" type="number" class="flex h-5 w-full grow select-none items-center justify-center bg-transparent text-center text-sm outline-none" />
                                                <button type="button" class="i-lucide-minus size-8 text-warning"></button>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                            <!-- footer -->
                            <div class="flex items-center justify-between border-t p-5">
                                <div class="flex flex-col items-center">
                                    <p class="text-text/60">مبلغ قابل پرداخت</p>
                                    <div class="flex items-center gap-x-1 text-primary">
                                        <p class="text-lg font-bold">10,130,000</p>
                                        <p class="text-sm">تومان</p>
                                    </div>
                                </div>
                                <a href="checkout-shipping-not-selected.html">
                                    <button class="w-32 rounded-md bg-primary-btn py-3 text-white duration-200 hover:bg-primary-btn/80">ثبت سفارش</button>
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <!-- Theme -->
                <div>
                    <button onclick="toggleDark(event)" class="icon-btn h-10 w-10">
                        <span class="i-carbon-moon !h-6 !w-6 dark:i-carbon-sun"></span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Bottom -->
        <?php echo $__env->make('layouts.blesser.header-desktop-bottom', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
    <!-- Mobile-->
    <div class="block lg:hidden">
        <!-- Top -->
        <div id="headerMobileTop" class="container relative inset-x-0 z-30 bg-muted pb-4 pt-2 transition-transform duration-300">
            <div class="flex items-center justify-between">
                <!-- Image -->
                <a href="<?php echo e(route('home')); ?>">
                    <img class="h-6" src="<?php echo e(asset('uploads/'.getSiteLogo())); ?>" alt="<?php echo e(getSiteName()); ?>" />
                </a>
                <div class="flex gap-2">

                    <!-- Favorite -->
                    <a href="<?php echo e(route("user.dashboard" , ['tab'=>'faviorit'])); ?>" class="icon-btn relative h-10 w-10 border-primary">
                        <div class="i-lucide-heart h-6 w-6"></div>
                    </a>

                    <!-- Theme -->
                    <button onclick="toggleDark(event)" class="icon-btn h-10 w-10">
                        <span class="i-carbon-moon !h-6 !w-6 dark:i-carbon-sun"></span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Bottom -->
        <div class="px-3">

            <div class="absolute inset-x-0 top-full flex-grow bg-muted pb-1.5 transition-all duration-200">
                <div>
                    <div class="container flex items-center">
                        <div class="group flex w-full items-center overflow-hidden rounded-lg border bg-background pr-2 duration-200 focus-within:border-primary">
                            <div class="i-carbon-search h-6 w-6 text-text/60"></div>
                            <form action="<?php echo e(route('shop')); ?>" method="get" class="h-10">
                                <label for="mobileSearchInput" class="sr-only">
                                    <?php echo e(__('Search')); ?>

                                </label>
                                <input name="search" id="mobileSearchInput" type="text" autocomplete="off" placeholder="<?php echo e(__('search')); ?>" class="duration-400 h-10 w-full bg-transparent px-2 outline-none placeholder:text-sm placeholder:duration-200 focus:placeholder:-translate-x-2" />
                                <button type="submit" class="ml-2 hidden h-6 w-6 items-center justify-center rounded-lg border bg-background p-px text-text/60">
                                    <span class="i-lucide-x h-4 w-4"></span>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if(false): ?>
        <div class="px-3">

            <div id="headerMobileNavigation" data-onscrollclass="-translate-y-full" class="absolute inset-x-0 top-full flex-grow bg-muted pb-1.5 transition-all duration-200">
                <div>
                    <div class="container flex items-center">
                        <div onclick="mobileSearchUnFocus()" id="headerMobileSearchCloseIcon" class="i-lucide-arrow-right h-0 w-0 text-text/80 duration-200"></div>
                        <div class="group flex w-full items-center overflow-hidden rounded-lg border bg-background pr-2 duration-200 focus-within:border-primary">
                            <div class="i-carbon-search h-6 w-6 text-text/60"></div>
                            <label for="mobileSearchInput" class="sr-only">Mobile Search</label>
                            <input id="mobileSearchInput" type="text" autocomplete="off" onkeyup="mobileSearchOnType(event)" onfocus="mobileSearchOnFocus()" placeholder="جستجو در بلسر" class="duration-400 h-10 w-full bg-transparent px-2 outline-none placeholder:text-sm placeholder:duration-200 focus:placeholder:-translate-x-2" />
                            <button id="mobileSearchClearButton" onclick="mobileSearchClearValue()" class="ml-2 hidden h-6 w-6 items-center justify-center rounded-lg border bg-background p-px text-text/60">
                                <span class="i-lucide-x h-4 w-4"></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Search Result -->
        <div id="headerMobileSearchResult" class="relative z-40 hidden px-3">
            <div class="fixed inset-0 mt-[64px] h-[calc(100dvh-64px)] bg-muted">
                <div class="h-full space-y-6 overflow-y-auto p-5">
                    <!-- Product Result -->
                    <div class="swiper search-result-slider">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <a href="./product-detail.html" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                                    <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" class="h-20 w-20 rounded-lg object-cover" />
                                    <p class="line-clamp-2 text-text/95">نایک زوم پگاسوس توربو مشکی</p>
                                </a>
                            </div>
                            <div class="swiper-slide">
                                <a href="./product-detail.html" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                                    <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" class="h-20 w-20 rounded-lg object-cover" />
                                    <p class="line-clamp-2 text-text/95">نایک زوم پگاسوس توربو مشکی</p>
                                </a>
                            </div>
                            <div class="swiper-slide">
                                <a href="./product-detail.html" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                                    <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" class="h-20 w-20 rounded-lg object-cover" />
                                    <p class="line-clamp-2 text-text/95">نایک زوم پگاسوس توربو مشکی</p>
                                </a>
                            </div>
                            <div class="swiper-slide">
                                <a href="./product-detail.html" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                                    <img src="/assets/themes/blesser/images/p1.png" alt="نایک زوم پگاسوس توربو مشکی" class="h-20 w-20 rounded-lg object-cover" />
                                    <p class="line-clamp-2 text-text/95">نایک زوم پگاسوس توربو مشکی</p>
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- Brand Result -->
                    <ul class="space-y-2">
                        <li>
                            <a href="./shop.html" class="flex items-center gap-2 py-2 duration-200 hover:text-primary">
                                برند نایک
                                <span class="i-ic-outline-arrow-outward"></span>
                            </a>
                        </li>
                        <li>
                            <a href="./shop.html" class="flex items-center gap-2 py-2 duration-200 hover:text-primary">
                                برند نیو بالانس
                                <span class="i-ic-outline-arrow-outward"></span>
                            </a>
                        </li>
                    </ul>

                    <!-- User Recent Search -->
                    <div>
                        <div class="flex items-center justify-between">
                            <div>جستجوهای اخیر شما</div>
                            <button class="flex items-center gap-2 text-sm text-warning duration-200 hover:text-warning/80">
                                حذف همه
                                <i class="i-lucide-trash size-5"></i>
                            </button>
                        </div>

                        <div class="flex flex-wrap gap-4 pt-3">
                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                        </div>
                    </div>
                    <!-- Popular Search -->
                    <div>
                        <div>جستجوهای پرتکرار</div>
                        <div class="flex flex-wrap gap-4 pt-3">
                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                            <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</header>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/layouts/blesser/header.blade.php ENDPATH**/ ?>