<?php $__env->startSection('title', 'Shop Profiles'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800"><?php echo e(__('Shop Profiles')); ?></h1>
        <a href="<?php echo e(route('admin.shops.create')); ?>" class="btn  btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50"></i> <?php echo e(__('Create New Shop')); ?>

        </a>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Shops List')); ?></h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered align-middle text-center" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Logo')); ?></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Owner')); ?></th>
                            <th><?php echo e(__('Email')); ?></th>
                            <th><?php echo e(__('Phone')); ?></th>
                            <th><?php echo e(__('Approved')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <?php if($shop->logo): ?>
                                <img data-scope="shop-profile" onerror="window.app.handleBrokenImage(this)" src="<?php echo e(asset('uploads/' . $shop->logo)); ?>" alt="<?php echo e($shop->name); ?>" style="max-height: 50px; max-width: 100px;">
                                <?php else: ?>
                                N/A
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($shop->name); ?></td>
                            <td><?php echo e($shop->user?->name ?? 'N/A'); ?></td>
                            <td><?php echo e($shop->email); ?></td>
                            <td><?php echo e($shop->phone); ?></td>
                            <td class="d-flex flex-wrap justify-content-around align-items-center">
                                <?php if($shop->is_approved): ?>
                                <span class="badge bg-success"><?php echo e(__('Yes')); ?></span>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shop.profile.unapprove')): ?>
                                <form action="<?php echo e(route('admin.shops.unapprove', $shop)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to unapprove this shop?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>
                                    <button type="submit" class="btn  btn-warning"><?php echo e(__('Unapprove')); ?></button>
                                </form>
                                <?php endif; ?>
                                <?php else: ?>
                                <span class="badge bg-danger"><?php echo e(__('No')); ?></span>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shop.profile.approve')): ?>
                                <form action="<?php echo e(route('admin.shops.approve', $shop)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to approve this shop?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>
                                    <button type="submit" class="btn  btn-success"><?php echo e(__('Approve')); ?></button>
                                </form>
                                <?php endif; ?>

                                <?php endif; ?>
                            </td>
                            <td class="">
                                <div class="d-flex flex-wrap justify-content-around align-items-center">
                                    <a href="<?php echo e(route('admin.shops.show', $shop)); ?>" class="btn  btn-info" title="View"><i class="bx bxs-show m-0 p-0"></i></a>
                                    <a href="<?php echo e(route('admin.shops.edit', $shop)); ?>" class="btn  btn-warning" title="Edit"><i class="bx bxs-edit m-0 p-0"></i></a>
                                    <form action="<?php echo e(route('admin.shops.destroy', $shop)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this shop? This action cannot be undone.');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn  btn-danger" title="Delete"><i class="bx bxs-trash m-0 p-0"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center"><?php echo e(__('No shops found.')); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center">
                <?php echo e($shops->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/shop-profile/index.blade.php ENDPATH**/ ?>