<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4><?php echo e(__('Question Details')); ?></h4>
        <div>
            <a href="<?php echo e(route('admin.faq.questions.edit', $question->id)); ?>" class="btn btn-primary btn-sm"><?php echo e(__('Edit')); ?></a>
            <form action="<?php echo e(route('admin.faq.questions.destroy', $question->id)); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('<?php echo __('Are you sure?') ?>')"><?php echo e(__('Delete')); ?></button>
            </form>
        </div>
    </div>
    <div class="card-body">
        <p><strong><?php echo e(__('Title:')); ?></strong> <?php echo e($question->title); ?></p>
        <p><strong><?php echo e(__('Slug:')); ?></strong> <?php echo e($question->slug); ?></p>
        <p><strong><?php echo e(__('Body:')); ?></strong> <?php echo e($question->body); ?></p>
        <p><strong><?php echo e(__('Category:')); ?></strong> <?php echo e(\Artemis\Faq\Models\Category::find($question->category_id)->name); ?></p>
        <p><strong><?php echo e(__('Status:')); ?></strong> <?php echo e($question->status); ?></p>
        <p><strong><?php echo e(__('User ID:')); ?></strong> <?php echo e($question?->user->name); ?></p>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header">
        <h5><?php echo e(__('Answers')); ?></h5>
    </div>
    <div class="card-body">
        <?php $__empty_1 = true; $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="mb-4 border-bottom pb-3">
            <p><strong><?php echo e(__('Answer by:')); ?></strong> <?php echo e($answer->user?->name ?? __('Unknown')); ?></p>
            <p><?php echo e($answer->body); ?></p>
            <div class="ms-3">
                <strong><?php echo e(__('Comments:')); ?></strong>
                <?php $__empty_2 = true; $__currentLoopData = $answer->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                <div class="border rounded p-2 my-1">
                    <small><strong><?php echo e($comment->user?->name ?? __('Unknown')); ?>:</strong></small>
                    <span><?php echo e($comment->body); ?></span>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                <p class="text-muted"><?php echo e(__('No comments.')); ?></p>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p><?php echo e(__('No answers yet.')); ?></p>
        <?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/faq/questions/show.blade.php ENDPATH**/ ?>