<div class="container py-4">
    <h2 class="h4 fw-bold mb-4">Editing Page: <?php echo e($page->title); ?></h2>

    
    <div class="mb-4">
        <h5 class="fw-bold">Add Component to Page</h5>
        <div class="row row-cols-2 row-cols-sm-3 row-cols-md-4 g-3">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col">
                <button wire:click="addComponent('<?php echo e($name); ?>')" type="button" class="btn btn-outline-primary w-100 py-3">
                    <div class="fs-4">📦</div>
                    <div class="small fw-semibold mt-1"><?php echo e($class::label()); ?></div>
                </button>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    
    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
    $componentClass = $components[$item['component']] ?? null;
    $fields = $componentClass ? $componentClass::fields() : [];
    ?>

    <div class="card mb-4" wire:key="item-<?php echo e($index); ?>">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Component #<?php echo e($index + 1); ?> <small class="text-muted">(<?php echo e($componentClass::label() ?? 'Unknown'); ?>)</small></span>
            <button wire:click="removeItem(<?php echo e($index); ?>)" class="btn btn-sm btn-outline-danger">Remove</button>
        </div>
        <div class="card-body">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            $name = $field['name'];
            $type = $field['type'] ?? 'text';
            $label = $field['label'] ?? ucfirst($name);
            ?>

            <div class="mb-3">
                <label class="form-label"><?php echo e($label); ?></label>

                <!--[if BLOCK]><![endif]--><?php if(in_array($type, ['text', 'textarea'])): ?>
                <input type="text" wire:model="items.<?php echo e($index); ?>.settings.<?php echo e($name); ?>" class="form-control" />

                <?php elseif($type === 'image'): ?>
                <div class="d-flex flex-column gap-2">
                    <!--[if BLOCK]><![endif]--><?php if(!empty($items[$index]['settings'][$name])): ?>
                    <div class="d-flex justify-content-center">

                        <img src="<?php echo e($items[$index]['settings'][$name]); ?>" class="img-fluid" style="max-height: 120px;">
                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <button type="button"
                        class="btn btn-outline-secondary btn-sm"
                        wire:click="$dispatch('open-file-picker', { model: '<?php echo e('items.' . $index . '.settings.' . $name); ?>' })">
                        Select Image
                    </button>
                </div>

                <?php elseif($type === 'repeater'): ?>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $items[$index]['settings'][$name] ?? [[]]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subIndex => $subItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="border rounded p-3 mb-3 bg-light" wire:key="item-<?php echo e($index); ?>-repeater-<?php echo e($subIndex); ?>">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $field['fields']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $subName = $subField['name'];
                    $subType = $subField['type'] ?? 'text';
                    $subLabel = $subField['label'] ?? ucfirst($subName);
                    ?>

                    <div class="mb-2">
                        <label class="form-label small"><?php echo e($subLabel); ?></label>

                        <!--[if BLOCK]><![endif]--><?php if($subType === 'text'): ?>
                        <input type="text"
                            wire:model="items.<?php echo e($index); ?>.settings.<?php echo e($name); ?>.<?php echo e($subIndex); ?>.<?php echo e($subName); ?>"
                            class="form-control form-control-sm" />

                        <?php elseif($subType === 'image'): ?>
                        <div class="d-flex flex-column gap-2">
                            <!--[if BLOCK]><![endif]--><?php if(!empty($items[$index]['settings'][$name][$subIndex][$subName])): ?>
                            <div class="d-flex justify-content-center">
                                <img src="<?php echo e($items[$index]['settings'][$name][$subIndex][$subName]); ?>"
                                    class="img-fluid" style="max-height: 100px;">
                            </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <button type="button"
                                class="btn btn-outline-secondary btn-sm"
                                wire:click="$dispatch('open-file-picker', { model: '<?php echo e('items.' . $index . '.settings.' . $name . '.' . $subIndex . '.' . $subName); ?>' })">
                                Select Image
                            </button>
                        </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                    <button wire:click.prevent="removeRepeater(<?php echo e($index); ?>, '<?php echo e($name); ?>', <?php echo e($subIndex); ?>)"
                        class="btn btn-sm btn-outline-danger">Remove</button>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                <button wire:click.prevent="addRepeater(<?php echo e($index); ?>, '<?php echo e($name); ?>')"
                    class="btn btn-sm btn-outline-primary">+ Add Item</button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

    <div class="mt-4">
        <button wire:click="save" class="btn btn-primary">Save Page</button>
        <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
        <div class="text-success small mt-2"><?php echo e(session('message')); ?></div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.components.file-picker-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-2499097663-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/livewire/admin/page-item-edit.blade.php ENDPATH**/ ?>