<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['product' => null]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['product' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<div>
    <div class="border border-3 p-4 rounded mb-3">
        <div class="row g-3">
            <!-- product status -->
            <div id="product-status-container" class="col-12">
                <label for="status" class="form-label"><?php echo e(__('Status')); ?></label>
                <select class="form-select" name="status" id="status">
                    <?php if (\Illuminate\Support\Facades\Blade::check('hasrole', 'Shop')): ?>
                    <option value="<?php echo e(App\Enums\ProductStatusEnum::Review->value); ?>" selected> <?php echo e(App\Enums\ProductStatusEnum::Review->value); ?> </option>
                    <?php endif; ?>
                    <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'Administrator|Admin')): ?>
                    <?php $__currentLoopData = App\Enums\ProductStatusEnum::values(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($status); ?>"> <?php echo e(__($status)); ?> </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                </select>
            </div>

            <!-- product slug -->
            <div id="product-slug-container" class="mb-3 col-12">
                <label class="form-label"> <?php echo e(__('slug')); ?> </label>
                <input type="text" name="slug" class="form-control" dir="ltr" value="<?php echo e(old('slug' ,$product?->slug)); ?>">
                <small class="d-block text-align-justify">
                    <?php echo e(__('In this section, enter the text that should be displayed in the address bar in English, if left blank, the product title will be placed as a default.')); ?>

                </small>
            </div>

            <!-- product short description -->
            <div id="product-short-desc-container" class="mb-3 col-12">
                <label class="form-label"> <?php echo e(__('summery')); ?> </label>
                <textarea class="form-control w-100" name="short_description" id="" rows="5"><?php echo e(old('short_description' ,$product?->short_description)); ?></textarea>
            </div>
        </div>
    </div>

    <div class="border border-3 p-4 rounded mb-3">
        <div class="row g-3">

            <div class="row row-cols-1 row-cols-md-3 row-cols-lg-3 g-3">
                <div id="product-length-container" class="mb-3 ">
                    <label class="form-label"> <?php echo e(__('Length')); ?> </label>
                    <input type="text" name="length" class="form-control" dir="ltr" value="<?php echo e(old('length',$product?->length)); ?>">
                </div>
                <div id="product-width-container" class="mb-3 ">
                    <label class="form-label"> <?php echo e(__('Width')); ?> </label>
                    <input type="text" name="width" class="form-control" dir="ltr" value="<?php echo e(old('width',$product?->width)); ?>">
                </div>
                <div id="product-height-container" class="mb-3 ">
                    <label class="form-label"> <?php echo e(__('Height')); ?> </label>
                    <input type="text" name="height" class="form-control" dir="ltr" value="<?php echo e(old('height',$product?->height)); ?>">
                </div>
            </div>

            <!-- is this product a second hand product? -->
            <div id="product-second-hand-container" class="form-check mb-3 col-12">
                <input class="form-check-input" type="checkbox" value="true" name="consumable" id="consumable" <?php echo (old('consumable', $product?->consumable) == true) ? 'checked' : '' ?>>
                <label class="form-check-label" for="consumable">
                    <?php echo e(__('consumable product')); ?>

                </label>
            </div>
            <!-- is this product a second hand product? -->
            <div id="product-second-hand-container" class="form-check mb-3 col-12">
                <input class="form-check-input" type="checkbox" value="true" name="second_hand" id="second_hand" <?php echo (old('second_hand', $product?->second_hand) == true) ? 'checked' : '' ?>>
                <label class="form-check-label" for="second_hand">
                    <?php echo e(__('second hand product')); ?>

                </label>
            </div>


            <!-- input for product price   -->
            <div id="product-price-container" class="mb-3 col-12">
                <label class="form-label"> <?php echo e(__('price')); ?> </label>
                <input type="text" name="price" class="form-control" dir="ltr" value="<?php echo e(old('price',$product?->price)); ?>">
            </div>

            <!-- input for product price discount   -->
            <div id="product-price-with-discount-container" class="mb-3 col-12">
                <label class="form-label"> <?php echo e(__('price with discount')); ?> </label>
                <input type="text" name="discount_price" class="form-control" dir="ltr" value="<?php echo e(old('discount_price',$product?->discount_price)); ?>">
            </div>

            <!-- input for product off rate   -->
            <div id="product-off-rate-container" class="mb-3 col-12">
                <label class="form-label"> <?php echo e(__('OFF rate')); ?> </label>
                <input type="text" name="off_rate" class="form-control" dir="ltr" value="<?php echo e(old('off_rate',$product?->off_rate)); ?>">
            </div>

            <!-- weight for product -->
            <div id="product-weight-price-container" class="mb-3 col-12">
                <label class="form-label"> <?php echo e(__('weight')); ?> (g) </label>
                <input type="text" name="weight" class="form-control" dir="ltr" value="<?php echo e(old('weight' ,$product?->weight)); ?>">
            </div>

            <!-- product inventory -->
            <div id="product-inventory-container" class="mb-3 col-12">
                <label class="form-label"> <?php echo e(__('inventory')); ?> </label>
                <input type="text" name="inventory" class="form-control" dir="ltr" value="<?php echo e(old('inventory',$product?->inventory)); ?>">
            </div>
            <!-- product tag -->
            <div class="mb-4">
                <label for="multiple-select-field" class="form-label">Basic multiple select</label>
                <select name="tag[]" class="form-select" id="multiple-select-field" data-placeholder="Choose anything" multiple>
                    <?php $__currentLoopData = \App\Models\Tag::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($tag->id); ?>" <?php echo e(in_array($tag->id, old('tags', $product?->tags->pluck('id')->toArray() ?? [])) ? 'selected' : ''); ?>> <?php echo e($tag->name); ?> </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/syndron/form/product/static-second-inputs.blade.php ENDPATH**/ ?>