<?php if($paginator->hasPages()): ?>
    <div class="flex items-center justify-center gap-1">

        
        <a href="<?php echo e($paginator->url(1)); ?>" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border bg-muted p-0 text-sm font-medium hover:bg-secondary disabled:opacity-50" aria-label="First Page" <?php if($paginator->onFirstPage()): ?> disabled <?php endif; ?>>
            <i class="i-lucide-chevrons-right"></i>
        </a>

        
        <a href="<?php echo e($paginator->previousPageUrl()); ?>" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border bg-muted p-0 text-sm font-medium hover:bg-secondary disabled:opacity-50" aria-label="Previous Page" <?php if(!$paginator->previousPageUrl()): ?> disabled <?php endif; ?>>
            <i class="i-lucide-chevron-right"></i>
        </a>

        
        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
            <?php if(is_string($element)): ?>
                <div class="flex h-9 w-9 items-center justify-center">
                    <i class="i-lucide-ellipsis text-text/80"></i>
                </div>
            <?php endif; ?>

            
            <?php if(is_array($element)): ?>
                <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e($url); ?>" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border <?php echo e($page == $paginator->currentPage() ? 'border-primary-btn bg-primary-btn text-white' : 'bg-muted hover:bg-secondary'); ?> p-0 text-sm font-medium">
                        <?php echo e($page); ?>

                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <a href="<?php echo e($paginator->nextPageUrl()); ?>" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border bg-muted p-0 text-sm font-medium hover:bg-secondary disabled:opacity-50" aria-label="Next Page" <?php if(!$paginator->nextPageUrl()): ?> disabled <?php endif; ?>>
            <i class="i-lucide-chevron-left"></i>
        </a>

        
        <a href="<?php echo e($paginator->url($paginator->lastPage())); ?>" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border bg-muted p-0 text-sm font-medium hover:bg-secondary disabled:opacity-50" aria-label="Last Page" <?php if($paginator->currentPage() == $paginator->lastPage()): ?> disabled <?php endif; ?>>
            <i class="i-lucide-chevrons-left"></i>
        </a>
    </div>
<?php endif; ?>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pagination/blesser.blade.php ENDPATH**/ ?>