<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'name', // The name for the radio button group (e.g., 'rating')
    'maxRating' => 5, // The maximum number of stars
    'value' => null, // The currently selected rating value (e.g., 3 for 3 stars)
    'idPrefix' => 'star', // A prefix for the input IDs to ensure uniqueness
    'use_wire' => false, // Whether to use Livewire for two-way data binding
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'name', // The name for the radio button group (e.g., 'rating')
    'maxRating' => 5, // The maximum number of stars
    'value' => null, // The currently selected rating value (e.g., 3 for 3 stars)
    'idPrefix' => 'star', // A prefix for the input IDs to ensure uniqueness
    'use_wire' => false, // Whether to use Livewire for two-way data binding
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<!-- From Uiverse.io by SelfMadeSystem -->
<div <?php echo e($attributes->merge(['class' => 'rating'])); ?> dir="ltr">
    <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= $maxRating; $i++): ?>
        <input
            type="radio"
            id="<?php echo e($idPrefix); ?>-<?php echo e($name); ?>-<?php echo e($i); ?>"
            name="<?php echo e($name); ?>"
            value="<?php echo e(($maxRating + 1) - $i); ?>"
            <?php if((int)$value === $i): ?> checked <?php endif; ?>
            <?php if($use_wire): ?> wire:model="<?php echo e($name); ?>" <?php endif; ?>
        />
        <label for="<?php echo e($idPrefix); ?>-<?php echo e($name); ?>-<?php echo e($i); ?>">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path pathLength="360" d="M12,17.27L18.18,21L16.54,13.97L22,9.24L14.81,8.62L12,2L9.19,8.62L2,9.24L7.45,13.97L5.82,21L12,17.27Z"></path>
            </svg>
        </label>
    <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/blesser/ui/form/rate.blade.php ENDPATH**/ ?>