<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4><?php echo e(__('Coupons')); ?></h4>
        <a class="btn btn-success" href="<?php echo e(route('admin.coupons.create')); ?>">
            <i class="fas fa-plus"></i> <?php echo e(__('Create New Coupon')); ?>

        </a>
    </div>

    <div class="card-body">
        <?php if(session('success')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>

        <?php if (isset($component)) { $__componentOriginal928d278381bb5fd251734dd365487ff3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal928d278381bb5fd251734dd365487ff3 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.syndron.ui.table','data' => ['columns' => [__('Code'), __('Type'), __('Amount'), __('Expire Date'), __('Usage Limit'), __('Actions')]]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('syndron.ui.table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([__('Code'), __('Type'), __('Amount'), __('Expire Date'), __('Usage Limit'), __('Actions')])]); ?>
            <?php $__empty_1 = true; $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($coupon->code); ?></td>
                <td><?php echo e(__($coupon->type  )); ?></td>
                <td>
                    <?php if($coupon->type === 'Percentage Discount'): ?>
                    <?php echo e($coupon->amount); ?>%
                    <?php else: ?>
                    
                    <?php echo e(number_format($coupon->amount, 2)); ?>

                    <?php endif; ?>
                </td>
                <td dir="rtl"><?php echo e($coupon->expire_date ? verta($coupon->expire_date)->format('Y-m-d H:i') : __('N/A')); ?></td>
                <td><?php echo e($coupon->usage_limit ?? __('Unlimited')); ?></td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenuButton<?php echo e($coupon->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(__('Actions')); ?>

                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton<?php echo e($coupon->id); ?>">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('coupon.edit')): ?>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.coupons.edit', $coupon->id)); ?>">
                                    <i class="fas fa-edit"></i> <?php echo e(__('Edit')); ?>

                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('coupon.delete')): ?>
                            <li>
                                <form action="<?php echo e(route('admin.coupons.destroy', $coupon->id)); ?>" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this coupon?') ?>');" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="dropdown-item text-danger" type="submit">
                                        <i class="fas fa-trash"></i> <?php echo e(__('Delete')); ?>

                                    </button>
                                </form>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="6" class="text-center"><?php echo e(__('No coupons found.')); ?></td>
            </tr>
            <?php endif; ?>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal928d278381bb5fd251734dd365487ff3)): ?>
<?php $attributes = $__attributesOriginal928d278381bb5fd251734dd365487ff3; ?>
<?php unset($__attributesOriginal928d278381bb5fd251734dd365487ff3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal928d278381bb5fd251734dd365487ff3)): ?>
<?php $component = $__componentOriginal928d278381bb5fd251734dd365487ff3; ?>
<?php unset($__componentOriginal928d278381bb5fd251734dd365487ff3); ?>
<?php endif; ?>

        <?php if($coupons->hasPages()): ?>
        <div class="mt-3">
            <?php echo e($coupons->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/coupon/index.blade.php ENDPATH**/ ?>