<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['wire' => false , 'address' , 'selection' => false, 'selected' => false]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['wire' => false , 'address' , 'selection' => false, 'selected' => false]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>
<li <?php if($wire): ?> wire:key="address-<?php echo e($address->id); ?>" <?php endif; ?> class="">
    <div class="relative block rounded-lg border p-4 shadow hover:border-border/50 <?php if ($selected) echo "!border-primary"  ?>">
        <div class="mb-4 flex justify-between gap-x-2 sm:mb-2">
            <div class="line-clamp-1 text-sm text-text/95 xs:text-base">
                <div class="flex gap-1">
                    <div class="flex min-w-fit">
                        <p><?php echo e($address->province); ?></p>,
                        <p><?php echo e($address->city); ?></p>,
                    </div>
                    <p><?php echo e($address->address); ?></p>
                </div>
                <div class="flex gap-1">
                    <p> <?php echo e(__('plaque')); ?>: <?php echo e($address->plaque); ?></p>
                    <p> <?php echo e(__('unit')); ?>: <?php echo e($address->unit); ?></p>
                    <p> <?php echo e(__('zip-code')); ?>: <?php echo e($address->zip_code); ?></p>
                </div>
            </div>
        </div>
        <div class="flex flex-col justify-between gap-2 sm:flex-row sm:items-center">

            <p class="line-clamp-1 text-sm text-text/60">
                <?php echo e($address->owner_is_receiver ? $address->receiver_name : auth()->user()->name); ?>

            </p>

            <div class="flex w-full gap-2 sm:w-fit">
                <div>
                    <button wire:click="deleteAddress(<?php echo e($address->id); ?>)" wire:loading.attr="disabled"
                        wire:target="deleteAddress" type="button"
                        class="inline-flex h-8 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-warning/10 px-3 text-sm font-medium text-warning ring-offset-background transition-colors hover:bg-warning/20 focus-visible:outline-none focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50">
                        <div class="i-material-symbols-wrong-location-outline-rounded size-5"></div>
                        <?php echo e(__('Delete')); ?>

                        <div wire:loading wire:target="deleteAddress"
                            class="i-lucide-loader-circle animate-spin"></div>
                    </button>
                </div>
                <div>
                    <button type="button"
                        @click="if ($wire.$parent.modelId != <?php echo e($address->id); ?>) { $dispatch('update-action', { action:'update', modelId: <?php echo e($address->id); ?> }) }"
                        class="inline-flex h-8 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-success/10 px-3 text-sm font-medium text-success ring-offset-background transition-colors hover:bg-success/20 focus-visible:outline-none disabled:pointer-events-none disabled:opacity-50">
                        <div class="i-material-symbols-edit-location-alt-outline-rounded size-5"></div>
                        <?php echo e(__('Edit')); ?>

                    </button>
                </div>
                <!--[if BLOCK]><![endif]--><?php if($selection === true): ?>
                <div>
                    <button type="button"
                        @click="$dispatch('address-selected', { addressId:<?php echo e($address->id); ?> })"
                        class="inline-flex h-8 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-success/10 px-3 text-sm font-medium text-success ring-offset-background transition-colors hover:bg-success/20 focus-visible:outline-none disabled:pointer-events-none disabled:opacity-50">
                        <div class="i-material-symbols-edit-location-alt-outline-rounded size-5"></div>
                        <?php echo e(__('Select')); ?>

                    </button>
                </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
    </div>
</li>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/blesser/element/address-item.blade.php ENDPATH**/ ?>