<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-body">
            <h1 class="mb-4"><?php echo e($footerSection->key); ?></h1>

            <form action="<?php echo e(route('admin.settings.ui.footer-sections.update', $footerSection)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-3">
                    <label for="value"><?php echo e(__('Title')); ?></label>
                    <input type="text" name="value" class="form-control" value="<?php echo e(old('value', $footerSection->value)); ?>">
                </div>

                <div class="mb-3">
                    <label><?php echo e(__('Links')); ?></label>
                    <div id="links-container">
                        <?php
                        $links = is_array($footerSection->data) ? $footerSection->data['links'] : json_decode($footerSection->data , true)['links'] ?? [] ;
                        ?>
                        <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row g-2 mb-2">
                            <div class="col">
                                <input type="text" name="data[links][<?php echo e($i); ?>][label]" class="form-control" placeholder="Label" value="<?php echo e($link['label']); ?>">
                            </div>
                            <div class="col" dir="ltr">
                                <input type="text" name="data[links][<?php echo e($i); ?>][url]" class="form-control" placeholder="URL" value="<?php echo e($link['url']); ?>">
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <button type="button" onclick="addLink()" class="btn btn-sm btn-secondary mt-2"><?php echo e(__('Add Link')); ?></button>
                </div>

                <button type="submit" class="btn btn-success"><?php echo e(__('Save')); ?></button>
            </form>

        </div>
    </div>
</div>

<script>
    let linkIndex = <?php echo count($links)  ?>;

    function addLink() {
        const container = document.getElementById('links-container');
        const row = document.createElement('div');
        row.classList.add('row', 'g-2', 'mb-2');
        row.innerHTML = `
            <div class="col">
                <input type="text" name="data[links][${linkIndex}][label]" class="form-control" placeholder="Label">
            </div>
            <div class="col">
                <input type="url" name="data[links][${linkIndex}][url]" class="form-control" placeholder="URL">
            </div>
        `;
        container.appendChild(row);
        linkIndex++;
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/settings/ui/footer-sections/edit.blade.php ENDPATH**/ ?>