<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="row g-0">

        <div x-data="{image : '<?php echo e($product->brand_img); ?>' }" class="col-md-4 border-end">
            <img x-bind:src="image" class="img-fluid w-100 square-box" alt="<?php echo e($product->title); ?>">
            <div class="row mb-3 row-cols-auto g-2 justify-content-center mt-3">
                <?php $__currentLoopData = $product->getMetaByKey('gallery'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col">
                    <img x-on:click="image = '<?php echo e($image->value); ?>' " src="<?php echo e($image->value); ?>" width="70" class="square-box border rounded cursor-pointer" alt="">
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>


        <div class="col-md-8">
            <div class="card-body">
                <h4 class="card-title">
                    <?php echo e($product->title); ?>

                </h4>

                <!-- Todo: d-flex  -->
                <div class="d-none gap-3 py-3">
                    <div class="cursor-pointer">
                        <i class='bx bxs-star text-warning'></i>
                        <i class='bx bxs-star text-warning'></i>
                        <i class='bx bxs-star text-warning'></i>
                        <i class='bx bxs-star text-warning'></i>
                        <i class='bx bxs-star text-secondary'></i>
                    </div>
                    <div>142 reviews</div>
                    <div class="text-success"><i class='bx bxs-cart-alt align-middle'></i> 134 orders
                    </div>
                </div>


                <div class="mb-3">
                    <span class="price h4">
                        <span <?php if($product->discount_price): ?> class="me-2 text-decoration-line-through text-secondary" <?php endif; ?>>
                            <?php echo e(is_numeric($product->price) ? number_format($product->price) : $product->price); ?>

                        </span>
                        <span>
                            <?php echo e(is_numeric($product->discount_price) ? number_format($product->discount_price) : $product->discount_price); ?>

                        </span>
                    </span>
                </div>


                <p class="card-text fs-6">
                    <?php echo e($product->short_description); ?>

                </p>
                <dl class="row">
                    <?php $__empty_1 = true; $__currentLoopData = $product->attribute; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <dt class="col-sm-3">
                        <?php echo e($attribute->attribute->label); ?>

                    </dt>
                    <dd class="col-sm-9">
                        <?php echo e($attribute->value); ?>

                    </dd>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                    <?php endif; ?>

                </dl>
                <hr>
                <div class="d-flex">
                    <a href="<?php echo e(route('product.details' , $product->slug)); ?>" class="btn btn-secondary" target="_blank"> <?php echo e(__('see product in shop')); ?> </a>

                    <?php if(auth()->user()->isAdmin()): ?>
                    <a href="<?php echo e(route('admin.product.edit' , ['product'=>$product->id ])); ?>" class="btn btn-secondary ms-2">
                        <?php echo e(__('Edit')); ?>

                    </a>
                    <form action="<?php echo e(route('admin.product.destroy' , $product->id)); ?>" method="post" class="ms-2" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this product?') ?>');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">
                            <?php echo e(__('Delete')); ?>

                        </button>
                    </form>
                    <?php endif; ?>
                </div>
                <hr>

                <?php if(Route::is('admin.shop.add.inventory')): ?>
                <div class="">
                    <h3>
                        <?php echo e(__('add this product to my inventory')); ?>

                    </h3>

                    <form action="<?php echo e(route('admin.shop.inventory.store')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="text" name="product_id" value="<?php echo e($product->id); ?>" hidden>
                        <div class="mb-3">
                            <?php if (isset($component)) { $__componentOriginald3892b455f1ab85ac79353b44f778953 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald3892b455f1ab85ac79353b44f778953 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.syndron.ui.form.number-input','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('syndron.ui.form.number-input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald3892b455f1ab85ac79353b44f778953)): ?>
<?php $attributes = $__attributesOriginald3892b455f1ab85ac79353b44f778953; ?>
<?php unset($__attributesOriginald3892b455f1ab85ac79353b44f778953); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald3892b455f1ab85ac79353b44f778953)): ?>
<?php $component = $__componentOriginald3892b455f1ab85ac79353b44f778953; ?>
<?php unset($__componentOriginald3892b455f1ab85ac79353b44f778953); ?>
<?php endif; ?>
                            <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"> <?php echo e($message); ?> </small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-3">
                            <label for="price"><?php echo e(__('Price')); ?></label>
                            <input type="text" name="price" class="form-control" id="price" value="<?php echo e($product->price); ?>" placeholder="<?php echo e(__('Price')); ?>">
                            <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"> <?php echo e($message); ?> </small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button class="btn btn-primary" type="submit">
                                <?php echo e(__('Add to my inventory')); ?>

                            </button>

                        </div>
                    </form>

                </div>
                <?php endif; ?>

                <!-- d-flex -->
                <div class="d-none  gap-3 mt-3">
                    <a href="#" class="btn btn-primary">Buy Now</a>
                    <a href="#" class="btn btn-outline-primary"><span class="text">Add to cart</span> <i
                            class='bx bxs-cart-alt'></i></a>
                </div>
                <!-- todo -->
            </div>
        </div>
    </div>

    <hr />

    <div class="card-body">
        <ul class="nav nav-tabs nav-primary mb-0" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link active" data-bs-toggle="tab" href="#primaryhome" role="tab"
                    aria-selected="true">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='bx bx-comment-detail font-18 me-1'></i>
                        </div>
                        <div class="tab-title"> <?php echo e(__('Product Description')); ?> </div>
                    </div>
                </a>
            </li>

            <li class="nav-item" role="presentation">
                <a class="nav-link" data-bs-toggle="tab" href="#primarycontact" role="tab"
                    aria-selected="false">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='bx bx-star font-18 me-1'></i>
                        </div>
                        <div class="tab-title">Reviews</div>
                    </div>
                </a>
            </li>
        </ul>

        <div class="tab-content pt-3">
            <div class="tab-pane fade show active" id="primaryhome" role="tabpanel">
                <?php echo $product->content; ?>

            </div>

            <div class="tab-pane fade" id="primarycontact" role="tabpanel">

            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/product/show.blade.php ENDPATH**/ ?>