<div>
    <!--[if BLOCK]><![endif]--><?php if($show): ?>
    <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5)">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Select or Upload Image</h5>
                    <button type="button" wire:click="$set('show', false)" class="btn-close"></button>
                </div>
                <div class="modal-body">
                    <ul class="nav nav-tabs" id="pickerTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#uploadTab">Upload</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#libraryTab">Library</button>
                        </li>
                    </ul>

                    <div class="tab-content mt-3">
                        <div class="tab-pane fade show active" id="uploadTab">
                            <input type="file" wire:model="uploadedFile" class="form-control">
                            <!--[if BLOCK]><![endif]--><?php if($uploadedFile): ?>
                            <img src="<?php echo e($uploadedFile->temporaryUrl()); ?>" class="img-fluid mt-2" style="max-height:150px;">
                            <button class="btn btn-primary mt-2" wire:click="uploadFile">Use this file</button>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="tab-pane fade" id="libraryTab">
                            <div class="row row-cols-2 row-cols-sm-3 row-cols-md-4 g-2">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col">
                                    <img src="<?php echo e($file); ?>" class="img-thumbnail cursor-pointer"
                                        style="height: 120px; object-fit: cover;"
                                        wire:click="selectFile('<?php echo e($file); ?>')">
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/livewire/admin/components/file-picker-modal.blade.php ENDPATH**/ ?>