<div class="mb-8 rounded-lg bg-muted px-2 py-3 shadow xl:px-4">
    <p class="mb-4 text-center text-sm font-medium xl:text-base"><?php echo e(__('new posts')); ?></p>
    <ul class="space-y-8">
        <?php $__currentLoopData = \App\Models\Post::latest()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li>
            <a href="<?php echo e(route('post.details', $post->slug)); ?>">
                <div class="group flex gap-x-2 xl:gap-x-4">
                    <div class="min-w-fit overflow-hidden rounded-xl">
                        <img src="<?php echo e(asset('uploads/' . $post->img)); ?>" alt="<?php echo e($post->title); ?>" class="aspect-[1.2/1] w-25 rounded-xl object-cover duration-300 group-hover:scale-110" />
                    </div>
                    <div class="flex flex-col gap-y-2">
                        <p class="line-clamp-2 text-sm text-text/90 xl:text-base"><?php echo e($post->title); ?></p>
                        <div class="flex items-center gap-2 text-text/60">
                            <div class="i-lucide-clock size-4"></div>
                            <p class="text-xs text-text/60 xl:text-sm"><?php echo e(verta($post->created_at)->format('Y / F / d')); ?></p>
                        </div>
                    </div>
                </div>
            </a>
        </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/blesser/element/sidebar/new-posts.blade.php ENDPATH**/ ?>