<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4"><?php echo e(__('Cache Manager')); ?></h2>

    <?php if(session('status')): ?>
    <div class="alert alert-success"><?php echo e(session('status')); ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('admin.settings.cache.refresh')); ?>" class="mb-3 d-flex align-items-center gap-3">
        <?php echo csrf_field(); ?>
        <label for="cacheable"><?php echo e(__('Select Cache Class')); ?>:</label>
        <select name="cacheable" id="cacheable" class="form-select w-auto">
            <?php $__currentLoopData = $cacheables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($label); ?>"><?php echo e($label); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.cache.refresh')): ?>
        <button formaction="<?php echo e(route('admin.settings.cache.refresh')); ?>" class="btn btn-primary">🔄 <?php echo e(__('Refresh')); ?></button>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.cache.clear')): ?>
        <button formaction="<?php echo e(route('admin.settings.cache.clear')); ?>" class="btn btn-warning">🧹 <?php echo e(__('Clear')); ?></button>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.cache.value')): ?>
        <button formaction="<?php echo e(route('admin.settings.cache.value')); ?>" class="btn btn-info">👁️ <?php echo e(__('View')); ?></button>
        <?php endif; ?>
    </form>

    <?php if(session('value')): ?>
    <div class="card mt-4">
        <div class="card-header">Cached Value</div>
        <div class="card-body">
            <pre><?php echo e(print_r(session('value'), true)); ?></pre>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/settings/cache/index.blade.php ENDPATH**/ ?>