<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['wire' => false ,'order']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['wire' => false ,'order']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>
<a href="<?php echo e($wire ? 'javascript:;' : ''); ?>" wire:click="showOrderDetails(<?php echo e($order->id); ?>)" class="block rounded-lg border p-4 shadow mb-3">
    <div class="flex items-center justify-between pb-6">
        <div class="flex items-center gap-x-2 text-white">
            <!-- <div class="i-lucide-circle-check size-6"></div> -->
            <p class="font-medium md:text-lg">
                <?php echo e(__($order->status)); ?>

            </p>
        </div>
        <div class="i-lucide-chevron-left size-6"></div>
    </div>
    <div class="mb-6 flex flex-col gap-6 xl:flex-row xl:justify-between xl:gap-16">
        <div class="flex flex-col gap-4 md:flex-row">
            <div class="flex items-center justify-between gap-x-2 md:justify-start">
                <div class="text-sm text-text/60 md:text-base">
                    <?php echo e(__('order number')); ?>

                </div>
                <div class="text-sm text-text/95 md:text-base">
                    <?php echo e($order->tracking_code); ?>

                </div>
            </div>
            <div class="flex items-center justify-between gap-x-2 md:justify-start">
                <div class="text-sm text-text/60 md:text-base">
                    <?php echo e(number_format($order->amount)); ?>

                </div>
                <div class="flex items-center gap-1 text-primary">
                    <div class="font-bold md:text-lg">
                        <?php echo e(number_format($order->amount_with_discount)); ?>

                    </div>
                    <div class="text-sm md:text-base">
                        <?php echo e(getCurrency()); ?>

                    </div>
                </div>
            </div>
            <div class="flex items-center justify-between gap-x-2 md:justify-start">
                <div class="text-sm text-text/60 md:text-base">
                    <?php echo e(__('order date')); ?>

                </div>
                <div class="flex items-center gap-1 text-text/95">
                    <?php echo e(verta($order->created_at)->format('Y/m/d')); ?>

                </div>
            </div>
        </div>
        <div class="hidden flex-grow flex-col gap-y-4">
            <div class="flex items-center gap-x-2 text-yellow-500 dark:text-yellow-400">
                <div class="i-ic-baseline-pending-actions size-5"></div>

                <p class="text-sm font-medium md:text-base">در انتظار تایید</p>
            </div>
            <div class="relative h-2 w-full rounded-full bg-secondary">
                <span class="absolute inset-y-0 right-0 rounded-full bg-yellow-500 dark:bg-yellow-400" style="width: 25%"></span>
            </div>
            <div class="flex items-center justify-between text-sm text-yellow-500 dark:text-yellow-400 md:text-base"><span> 30 / ارديبهشت / ۱۴۰۳</span><span> ساعت 44 : 20 </span></div>
        </div>
    </div>

    <!-- Items Image -->
    <div class="swiper small-product-image-swiper">
        <div class="swiper-wrapper">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="swiper-slide">
                <img src="<?php echo e($orderItem->item->brand_img); ?>" alt="<?php echo e($orderItem->item->title ?? ''); ?>" class="size-20 rounded-xl" />
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

        </div>
    </div>
</a>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/blesser/element/single-order-card.blade.php ENDPATH**/ ?>