<?php $__env->startSection('title', __('Orders')); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">

            <div class="card">
                <dic class="card-header d-flex justify-content-between">
                    <div>
                        <?php echo e(__('Order List')); ?>

                    </div>
                    <div>
                        <a class="btn btn-success" href="route('admin.orders.create')"><?php echo e(__('Create Order')); ?></a>
                    </div>
                </dic>
                <div class="card-body">
                    <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <?php if(session('error')): ?>
                    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo e(__('Tracking Code')); ?></th>
                                    <th><?php echo e(__('Customer Name')); ?></th>
                                    <th><?php echo e(__('Email')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Order Date')); ?></th>
                                    <th><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.orders.show', $order)); ?>"><?php echo e($order->tracking_code); ?></a>
                                    </td>
                                    <td><?php echo e($order->name); ?></td>
                                    <td><?php echo e($order->email); ?></td>
                                    <td><?php echo e(number_format($order->amount_with_discount ?? $order->amount)); ?></td>
                                    <td><span class="badge bg-primary"><?php echo e(__(ucfirst($order->status))); ?></span></td>
                                    <td><?php echo e(verta($order->created_at)->format('d F, Y | H:i')); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="btn btn-sm btn-info"><?php echo e(__('View')); ?></a>

                                        <?php if(false): ?>
                                        <a href="<?php echo e(route('admin.orders.edit', $order)); ?>" class="btn btn-sm btn-primary"><?php echo e(__('Edit')); ?></a>
                                        <?php endif; ?>
                                        <form action="<?php echo e(route('admin.orders.destroy', $order)); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this order?')?>');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger"><?php echo e(__('Delete')); ?></button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center"><?php echo e(__('No orders found.')); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        <?php echo e($orders->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/order/index.blade.php ENDPATH**/ ?>