<?php $__env->startSection('title', 'Shop Profile Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800"><?php echo e(__('Shop')); ?>: <?php echo e($shop->name); ?></h1>
        <div>
            <a href="<?php echo e(route('admin.shops.edit', $shop)); ?>" class="btn btn-sm btn-warning shadow-sm">
                <i class="fas fa-edit fa-sm text-white-50"></i> <?php echo e(__('Edit Shop')); ?>

            </a>
            <a href="<?php echo e(route('admin.shops.index')); ?>" class="btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> <?php echo e(__('Back to List')); ?>

            </a>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Shop Information')); ?></h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3 text-center">
                    <?php if($shop->logo): ?>
                    <img src="<?php echo e(asset('uploads/' . $shop->logo)); ?>" alt="<?php echo e($shop->name); ?> Logo" class="img-fluid rounded mb-3" style="max-height: 200px;">
                    <?php else: ?>
                    <p class="text-muted"><?php echo e(__('No logo uploaded')); ?>.</p>
                    <?php endif; ?>
                    <p>
                        <strong><?php echo e(__('Status')); ?>:</strong>
                        <?php if($shop->is_approved): ?>
                        <span class="badge bg-success"><?php echo e(__('Approved')); ?></span>
                        (on <?php echo e($shop->approved_at ? \Carbon\Carbon::parse($shop->approved_at)->format('M d, Y') : 'N/A'); ?>)
                        <?php else: ?>
                        <span class="badge bg-warning text-dark"><?php echo e(__('Pending Approval')); ?></span>
                        <?php endif; ?>
                    </p>
                </div>
                <div class="col-md-9">
                    <dl class="row">
                        <dt class="col-sm-3"><?php echo e(__('Shop Name')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->name); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Slug')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->slug); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Owner')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->user?->name ?? 'N/A'); ?> (<?php echo e($shop->user?->email ?? ''); ?>)</dd>

                        <dt class="col-sm-3"><?php echo e(__('Email')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->email); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Phone')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->phone); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Address')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->address); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('City')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->city); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('State/Province')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->state ?? 'N/A'); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Postal Code')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->postal_code); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Country')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->country); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Description')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->description ?? 'N/A'); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Created At')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->created_at->format('M d, Y H:i A')); ?></dd>

                        <dt class="col-sm-3"><?php echo e(__('Last Updated')); ?>:</dt>
                        <dd class="col-sm-9"><?php echo e($shop->updated_at->format('M d, Y H:i A')); ?></dd>
                    </dl>
                </div>
            </div>
        </div>
        <div class="card-footer d-flex justify-content-end">
            <?php if($shop->is_approved): ?>
            <form action="<?php echo e(route('admin.shops.unapprove', $shop)); ?>" method="POST" class="d-inline me-2" onsubmit="return confirm('Are you sure you want to unapprove this shop?');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <button type="submit" class="btn btn-warning"><?php echo e(__('Unapprove Shop')); ?></button>
            </form>
            <?php else: ?>
            <form action="<?php echo e(route('admin.shops.approve', $shop)); ?>" method="POST" class="d-inline me-2" onsubmit="return confirm('Are you sure you want to approve this shop?');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <button type="submit" class="btn btn-success"><?php echo e(__('Approve Shop')); ?></button>
            </form>
            <?php endif; ?>
            <form action="<?php echo e(route('admin.shops.destroy', $shop)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this shop? This action cannot be undone.');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger"><?php echo e(__('Delete Shop')); ?></button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/shop-profile/show.blade.php ENDPATH**/ ?>