<section class="container py-10">
    <div class="mb-6 flex items-center justify-between gap-x-6 text-nowrap">
        <h4 class="font-semiBold lg:text-xl"><?php echo e($title); ?></h4>
        <div class="h-[0.25px] w-full bg-secondary"></div>
        <a href="<?php echo e($link); ?>">
            <div class="flex cursor-pointer items-center gap-x-2 text-sm text-primary duration-200 hover:text-primary/80 lg:text-base">
                <p>
                    <?php echo e(__('see all')); ?>

                </p>
                <i class="i-carbon-chevron-left"></i>
            </div>
        </a>
    </div>

    <div>
        <div class="swiper product-slider !px-px pt-4">
            <div class="swiper-wrapper py-px">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="swiper-slide">
                    <div class="border-gradient relative rounded-[--product-card-radius] p-px [--product-card-radius:theme(borderRadius.2xl)] before:absolute before:-inset-px before:h-[calc(100%+2px)] before:w-[calc(100%+2px)] before:rounded-[--product-card-radius] before:content-['']">
                        <a href="<?php echo e(route('product.details' ,$product->slug)); ?>" class="relative block overflow-hidden rounded-[calc(var(--product-card-radius)-1px)] bg-muted">
                            <div class="mb-4 bg-secondary p-2 lg:p-4">
                                <img src="<?php echo e($product->brand_img); ?>" alt="<?php echo e($product->title); ?>" class="aspect-[1/1] w-full rounded-xl object-cover" />
                            </div>

                            <div class="gap-x-1 text-end font-bold text-primary mb-1 px-2 lg:px-4 ">
                                <?php if($product->discount_price != 0 && $product->discount_price != null): ?>
                                <div class="h-5 text-end text-sm text-text/50 xs:text-base">
                                    <del>
                                        <?php echo e(number_format($product->price)); ?> <?php echo e(getCurrency()); ?>

                                    </del>
                                </div>
                                <span class="text-sm xs:text-base"><?php echo e(number_format($product->discount_price)); ?></span>
                                <span class="text-sm font-light"><?php echo e(getCurrency()); ?></span>
                                <?php else: ?>
                                <div class="h-5 text-end text-sm text-text/50 xs:text-base">

                                </div>
                                <span class="text-sm xs:text-base"><?php echo e(number_format($product->price)); ?></span>
                                <span class="text-sm font-light"><?php echo e(getCurrency()); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="h-8 px-2 lg:px-4"></div>
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/blesser/element/product-slider.blade.php ENDPATH**/ ?>