<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        Schema::create(prefixedTable('taggables'), function (Blueprint $table) {
            $table->foreignId('tag_id')->constrained(prefixedTable('tags'))->onDelete('cascade');
            $table->morphs('taggable');
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists(prefixedTable('taggables'));
    }
};
