<?php

namespace Artemis\Faq\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

abstract class Controller
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    
    protected function getPerPage(Request $request, string $key = 'per_page'): int
    {
        return (int)$request->query($key, $this->getDefaultPerPage());
    }
    
    protected function getPage(Request $request, string $key = 'page'): int
    {
        return (int)$request->query($key, $this->getDefaultPage());
    }
    
    protected function getDefaultPage(): int
    {
        return config('artemis.faq.paginate.default_page');
    }
    
    protected function getDefaultPerPage(): int
    {
        return config('artemis.faq.paginate.per_page');
    }
}