<?php

namespace Artemis\Faq\Http\Controllers\api\v1;

use Str;
use Artemis\Faq\Models\Category;
use Illuminate\Http\JsonResponse;
use Artemis\Faq\Http\Resources\CategoryResource;
use Artemis\Faq\Http\Controllers\api\ApiController;
use Artemis\Faq\Http\Requests\CategoryStoreRequest;
use Artemis\Faq\Http\Requests\CategoryUpdateRequest;
use Symfony\Component\HttpFoundation\Response as ResponseCode;

class CategoryController extends ApiController
{
    public function index(): JsonResponse
    {
        return $this->success(CategoryResource::collection(Category::all()));
    }
    
    public function store(CategoryStoreRequest $request): JsonResponse
    {
        Category::create($request->validated());
        
        return $this->success(status: ResponseCode::HTTP_CREATED);
    }
    
    public function show(Category $category): JsonResponse
    {
        return $this->success(new CategoryResource($category));
    }
    
    public function update(CategoryUpdateRequest $request, Category $category): JsonResponse
    {
        $category->update([
            'name' => $request->name ?? $category->name,
            'slug' => $request->slug ? Str::slug($request->slug) : $category->slug,
            'description' => $request->description ?? $category->description,
        ]);
        
        return $this->success();
    }
    
    public function destroy(Category $category): JsonResponse
    {
        $category->delete();
        
        return $this->success();
    }
}
