<?php

namespace Artemis\Faq\Http\Requests;

use Auth;
use Illuminate\Foundation\Http\FormRequest;

class QuestionStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check();
    }
    
    public function rules(): array
    {
        return [
            'title' => ['required', 'string', 'min:3', 'max:255'],
            'slug' => ['sometimes', 'string', 'min:3', 'max:255', 'unique:questions,slug'],
            'body' => ['required', 'string', 'min:3', 'max:1000'],
            'category_id' => ['nullable', 'integer', 'exists:categories,id'],
        ];
    }
}
