<?php

namespace Artemis\Faq\Http\Resources;

use Illuminate\Http\Request;
use Artemis\Faq\Models\Taggable;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Taggable */
class TaggableResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'taggable_type' => class_basename($this->taggable_type),
            'taggable_id' => $this->taggable_id,
        ];
    }
}
