<?php

namespace Artemis\Faq\Models;

use Artemis\Faq\Traits\HasTablePrefix;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\User;

class Question extends Model
{
    use SoftDeletes, HasTablePrefix;

    protected $fillable = [
        'user_id',
        'title',
        'slug',
        'body',
        'category_id',
        'best_answer_id',
        'status',
        'views',
    ];

    public function answers(): HasMany
    {
        return $this->hasMany(Answer::class);
    }
    public function betsAnswer(): BelongsTo
    {
        return $this->belongsTo(Answer::class, 'best_answer_id');
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }
    public function flags(): HasMany
    {
        return $this->hasMany(Flag::class);
    }
    public function comments(): HasMany
    {
        return $this->hasMany(Comment::class);
    }
    public function tags()
    {
        return $this->morphToMany(Tag::class, 'taggable', getTablePrefix() . 'taggables')->using(Taggable::class);
    }
}
