<?php

namespace Artemis\Faq\Models;

use Artemis\Faq\Traits\HasTablePrefix;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Taggable extends Pivot
{
    use SoftDeletes, HasTablePrefix;
    
    protected $table = 'taggables';
    
    public function tag(): BelongsTo
    {
        return $this->belongsTo(Tag::class);
    }
    
    public function taggable(): MorphTo
    {
        return $this->morphTo();
    }
}
