<?php

namespace Artemis\Faq\Traits;

use App\Models\User;
use Artemis\Faq\Models\Flag;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;

/** @mixin Model */
trait Flaggable
{
    public function flags(): MorphMany
    {
        return $this->morphMany(Flag::class, 'flaggable');
    }
    
    public function flag(int|User $userId, string $reason): Flag
    {
        return $this->flags()->create([
            'user_id' => $userId instanceof User ? $userId->id : $userId,
            'reason' => $reason,
        ]);
    }
    
    public function isFlagged(): bool
    {
        return $this->flags()->exists();
    }
    
    public function flagCount(): int
    {
        return $this->flags()->count();
    }
}