<?php

namespace App\Enums;

use App\Traits\EnumToArray;

enum DeliveryTypeEnum: string
{
    use EnumToArray;
    /**
     * Standard ground shipping (typically 3–7 business days).
     */
    case Standard = 'standard';

    /**
     * Faster than Standard, usually 2–3 business days.
     */
    case Express = 'express';

    /**
     * Next-day delivery (must ship before cutoff time).
     */
    case NextDay = 'next_day';

    /**
     * Same-day delivery (available only in certain zones).
     */
    case SameDay = 'same_day';

    /**
     * Customer picks up from a designated locker (e.g. Amazon Locker).
     */
    case LockerPickup = 'locker_pickup';

    /**
     * Customer picks up in-store or at a kiosk.
     */
    case InStorePickup = 'in_store_pickup';

    /**
     * International shipping (cross-border).
     */
    case International = 'international';

    /**
     * Expedited handling for fragile/oversized items.
     */
    case FragileHandling = 'fragile_handling';

    /**
     * Bulk or freight shipping (for very large/heavy orders).
     */
    case Freight = 'freight';

    /**
     * Returns pickup (in case you need to schedule a courier to pick up a return).
     */
    case ReturnPickup = 'return_pickup';
}
