<?php

namespace App\Http\Actions;

use Illuminate\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class ChangeAppLocaleAction
{
    public function __invoke(Request $request)
    {
        App::setLocale($request->locale);
        session()->put('locale', $request->locale);
        if ($request->ajax() || (isset($request->ajax) && $request->ajax == true))
            return response()->json(['status' => true]);

        return redirect()->back()->with('status', __('Locale changed successfully'));
    }
}
