<?php

namespace App\Http\Actions\Pages;

use Illuminate\View\View;
use Illuminate\Http\Request;
use App\Services\Models\CartService;
use App\Services\Models\CouponService;

class CartCheckoutPageAction
{
    protected CartService $cart;

    public function __construct(CartService $cart)
    {
        $this->cart = $cart;
    }

    public function __invoke(Request $request): View
    {
        $couponDiscount = 0;
        $items = $this->cart->items();
        $total = $this->cart->total();
        $totalPayable = $this->cart->totalPayable();

        if ($request->has(key: 'coupon')) {
            $couponDiscount = (new CouponService)->checkCoupon(coupon: $request->coupon, user: auth()->user(), total: $totalPayable)->discount_amount;
            $this->cart->updateCoupon($request->coupon);
        }

        return view('pages.cart-checkout', compact('items', 'total', 'couponDiscount', 'totalPayable'));
    }
}
