<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Http\Controllers\Controller;
use App\Models\Delivery;
use App\Models\DeliveryEvent;
use Illuminate\Http\Request;

class DeliveryEventController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request, Delivery $delivery)
    {
        $events = DeliveryEvent::where('delivery_id', $delivery->id)->get();
        return view('pages.admin.deliveries.events.index', compact('delivery', 'events'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request, DeliveryEvent $delivery_event)
    {
        $delivery_id = $delivery_event->delivery_id;
        try {
            $delivery_event->delete();
            return redirect()->route('admin.deliveries.delivery-events.index', ['delivery' => $delivery_id])->with('success', __('Delivery event deleted successfully'));
        } catch (\Throwable $th) {
            return redirect()->route('admin.deliveries.delivery-events.index', ['delivery' => $delivery_id])->with('error', __('Something went wrong. Try again.'));
        }
    }
}
