<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Laravel\Pennant\Feature;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;

class FeatureController extends Controller
{
    // Show all features
    public function index()
    {
        $features = $this->getAllFeatureDefinitions();

        $statuses = collect($features)->mapWithKeys(function ($feature) {
            return [$feature => Feature::active($feature)];
        });

        return view('pages.admin.features.index', data: [
            'features' => $features,
            'statuses' => $statuses,
        ]);
    }

    // Toggle a single feature
    public function toggle(string $feature)
    {
        if (Feature::active($feature)) {
            Feature::deactivateForEveryone($feature);
        } else {
            Feature::activateForEveryone($feature);
        }

        return back()->with('status', "Feature '{$feature}' toggled.");
    }

    // Helper: get all defined feature filenames
    protected function getAllFeatureDefinitions(): array
    {
        $files = File::files(app_path('Features'));

        return collect($files)
            ->map(fn($file) => $file->getFilenameWithoutExtension())
            ->map(fn($name) => Str::kebab($name)) // Laravel Pennant uses kebab-case
            ->toArray();
    }
}
