<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\User;
use App\Models\Address;
use App\Models\DeliveryTime;
use App\Models\Coupon;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class OrderController extends Controller
{

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (auth()->user()->isAdmin()) {
            $orders = Order::latest()->paginate(15);
        }

        if (auth()->user()->isShop() && auth()->user()->hasShop()) {
            $shopId = auth()->user()->shop->id;
            $orders = Order::whereHas('items.inventory', function ($q) use ($shopId) {
                $q->where('shop_id', $shopId);
            })->with(['items' => function ($query) use ($shopId) {
                $query->whereHas('inventory', function ($q) use ($shopId) {
                    $q->where('shop_id', $shopId);
                });
            }, 'items.inventory'])
                ->latest()
                ->paginate(15);
        }
        return view('pages.admin.order.index', compact('orders'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pages.admin.order.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // TODO:
    }

    /**
     * Display the specified resource.
     */
    public function show(Order $order)
    {
        // Eager load relationships that will be displayed
        $order->load(['user', 'items', 'deliveries', 'metas', 'payments', 'createdBy', 'orderedBy', 'orderable', 'address', 'deliveryTime', 'coupon']);
        return view('pages.admin.order.show', compact('order'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Order $order)
    {
        // TODO:
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Order $order)
    {
        // TODO:
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Order $order)
    {
        try {
            $order->delete();
            return redirect()->route('admin.orders.index')->with('success', __('Order deleted successfully.'));
        } catch (\Exception $e) {
            // Log the error or handle it as per your application's needs
            return redirect()->route('admin.orders.index')->with('error', __('Failed to delete order. It might be associated with other records.'));
        }
    }
}
