<?php

namespace App\Http\Controllers\Admin\Settings;

use Illuminate\Http\Request;
use App\Cache\CategoryTreeCache;
use App\Cache\Contracts\Cacheable;
use App\Http\Controllers\Controller;

class CacheController extends Controller
{
    protected array $cacheables = [
        'CategoryTreeCache' => CategoryTreeCache::class,
        // Add more here...
    ];

    public function index()
    {
        return view('pages.admin.settings.cache.index', [
            'cacheables' => $this->cacheables
        ]);
    }

    public function resolveCache(string $class): Cacheable
    {
        return app($this->cacheables[$class] ?? throw new \Exception("Cache class not found"));
    }

    public function refresh(Request $request)
    {
        $this->resolveCache($request->cacheable)->refresh();
        return back()->with('status', __('Cache refreshed.'));
    }

    public function clear(Request $request)
    {
        $this->resolveCache($request->cacheable)->clear();
        return back()->with('status', __('Cache cleared.'));
    }

    public function value(Request $request)
    {
        $value = $this->resolveCache($request->cacheable)->get();
        return back()->with('status', __('Cache value fetched.'))->with('value', $value);
    }
}
