<?php

namespace App\Http\Controllers\Admin;

use App\Models\Tag;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Contracts\View\View;

class TagController extends Controller
{
    /**
     * Show the form for creating the resource.
     */

    public function index()
    {

        $tags = Tag::all();
        return view('pages.admin.tag.index', compact('tags'));
    }

    public function create(): View
    {
        return view('pages.admin.tag.create');
    }



    /**
     * Store the newly created resource in storage.
     */
    public function store(Request $request): \Illuminate\Http\RedirectResponse

    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'slug' => 'required|string|max:255|unique:tags,slug',
            'description' => 'nullable|string',
            'color' => 'nullable|string|max:7', // Assuming color is a hex code
        ]);


        $tag = Tag::create($data);

        return redirect()->route('admin.tags.index')->with('success', __('Tag created.'));
    }

    /**
     * Display the resource.
     */
    public function show()
    {
        //
    }

    /**
     * Show the form for editing the resource.
     */
    public function edit(Tag $tag): View
    {
        return view('pages.admin.tag.edit', compact('tag'));
    }


    /**
     * Update the resource in storage.
     */
    public function update(Request $request ,Tag $tag): \Illuminate\Http\RedirectResponse
    {
       $data = $request->validate([
            'name' => 'required|string|max:255',
            'slug' => 'required|string|max:255|unique:tags,slug',
            'description' => 'nullable|string',
            'color' => 'nullable|string|max:7', // Assuming color is a hex code
        ]);


        $tag->update($data);

        return redirect()->route('admin.tags.index')->with('success', __('Tag updated.'));
    }

    /**
     * Remove the resource from storage.
     */
   public function destroy(Tag $tag)
    {
        $tag->delete();
        return redirect()->route('admin.tags.index')->with('success', __('Tag deleted.'));
    }
}
