<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Services\SweetAlert;
use Illuminate\Http\Request;
use App\Models\ProductInventory;
use App\Models\CategoryAttributeItem;
use App\Models\ProductInventoryVariant;

class InventoryVariantController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(ProductInventory $inventory)
    {
        $variants = ProductInventoryVariant::where('product_inventory_id', $inventory->id)->get();
        $product = $inventory->product;

        return view('pages.admin.shop.variant.index', compact('inventory', 'variants', 'product'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(ProductInventory $inventory)
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, ProductInventory $inventory)
    {
        $request->validate([
            'attributes' => 'required',
            'additional_price' => 'nullable|integer',
            'inventory_count' => 'required|integer|min:1',
        ]);
        $attributes = collect($request->get('attributes'));

        $items = CategoryAttributeItem::whereIn('id', $attributes->pluck('value'))
            ->whereIn('category_attribute_id', $attributes->pluck('id'))
            ->get()->keyBy('id');

        foreach ($attributes  as $key => $value) {
            $variant = ProductInventoryVariant::create([
                'user_id' => auth()->user()->id,
                'product_inventory_id' => $inventory->id,
                'category_attribute_id' => $value['id'],
                'category_attribute_item_id' => $value['value'],
                'item_key' => $key,
                'item_value' => $items[$value['value']]->item_value,
                'additional_price' => $request->additional_price,
                'inventory_count' => $request->inventory_count,
            ]);
        }

        return redirect()->route('admin.shop.inventory.variant.index', $inventory->id)->with('sweetalert', SweetAlert::success(__('success'), __('variant created successfully')));
    }

    /**
     * Display the specified resource.
     */
    public function show(ProductInventory $inventory, ProductInventoryVariant $productInventoryVariant)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ProductInventory $inventory, ProductInventoryVariant $variant)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ProductInventory $inventory, ProductInventoryVariant $variant)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ProductInventory $inventory, ProductInventoryVariant $variant)
    {
        $variant->delete();

        return redirect()->route('admin.shop.inventory.variant.index', $inventory->id)
            ->with('sweetalert', SweetAlert::success(__('success'), __('variant deleted successfully')));
    }
}
