<?php

namespace App\Http\Controllers;

use App\Events\PaymentPied;
use App\Models\Payment;
use Illuminate\Http\Request;
use Shetabit\Payment\Facade\Payment as ShetabitPayment;
use Shetabit\Multipay\Exceptions\InvalidPaymentException;
use Illuminate\Database\Eloquent\Builder;

class PaymentCallBackController extends Controller
{
    public function bitPay(Request $request)
    {
        $payment = Payment::where('transaction_id', $request->id_get)
            ->when($request->factorId, function (Builder $query, $factorId) {
                $query->where('tracking_code', $factorId);
            })->first();

        try {
            $receipt = ShetabitPayment::amount($payment->amount)->transactionId($request->trans_id)->verify();

            $ref_id = $receipt->getReferenceId();

            if (isset($ref_id) && $ref_id != null)
                $payment->update(
                    [
                        'data' => json_encode([
                            'referenceId' => $receipt->getDetail('referenceId'),
                            'amount' => $receipt->getDetail('amount'),
                            'cardNum' => $receipt->getDetail('cardNum'),
                            'factorId' => $receipt->getDetail('factorId'),
                        ])
                    ]
                );

            event(new PaymentPied($payment));

            return redirect()->route('payment', $payment->uuid);
        } catch (InvalidPaymentException $exception) {

            // when payment is not verified, it will throw an exception.
            // We can catch the exception to handle invalid payments.
            // getMessage method, returns a suitable message that can be used in user interface.

            echo $exception->getMessage();
        }
    }
}
